ORCA/M Asm65816 2.1.0

0001 A280              ;------------------------------------------------------------------------------
0002 A280              ; internal notes for gs/os caching routines.  these notes should never be
0003 A280              ; separated from the source code, they're listed here in no particular order.
0004 A280              ;
0005 A280              ; --  entry to each routine is via the system service table, the recognized
0006 A280              ; entry points are: cash_init, cash_add, cash_find, cash_delete, cash_del_vol,
0007 A280              ; cash_flsh_def and cash_shutdown.  all other routines are used by the
0008 A280              ; caching routines and are not known to anyone else.
0009 A280              ;
0010 A280              ; --  at the start of each entry point are comments describing briefly what
0011 A280              ; the routine does, what the inputs are and what the outputs are.  entry and
0012 A280              ; exit to each routine is always with full native mode and direct page equal
0013 A280              ; to gs/os direct page.
0014 A280              ;
0015 A280              ; --  cash_init and cash_shutdown are only used by gs/os, applications are
0016 A280              ; not allowed to make these calls.
0017 A280              ;
0018 A280              ; --  the cache size, (always in bytes) is determined by reading battery ram.
0019 A280              ; each tick is equal to 32K, if minus then the cache manager will assume 32K.
0020 A280              ; if 0 then the cache manager will assume 8K.  8K is about enough to boot the
0021 A280              ; system and not much else.
0022 A280              ;
0023 A280              ; --  the cache manager does not allocate to itself an amount of memory equal
0024 A280              ; to the cache size as specified by the user.  instead, the cache manager
0025 A280              ; keeps a running byte count of the remaining amount of memory that can be
0026 A280              ; used for the cache.  as the cache grows and shrinks, the cache manager updates
0027 A280              ; the remaining bytes left in the cache.
0028 A280              ;
0029 A280              ; --  the cache manager makes no assumptions about the size of the block that
0030 A280              ; wants to be cached.  it doesn't even have to be a power of 2.  i'm not sure
0031 A280              ; what the behavior of the mike memory manager is when the request for memory
0032 A280              ; is greater than his nominal memory size unit.
0033 A280              ;
0034 A280              ; --  the cache manager obtains memory from the mike memory manager.  (the
0035 A280              ; mike memory manager is a custom memory manager for gs/os.)  communications
0036 A280              ; to the mike memory manager is by virtual pointers.  vps are sort of like
0037 A280              ; handles, pointers are derived from vps by de-referencing them.
0038 A280              ;
0039 A280              ; --  depending on the state of the system, there can be cases where the cache
0040 A280              ; manager cannot get memory even though it's own running byte count says
0041 A280              ; there's room.  this usually happens when the system has no more free memory.
0042 A280              ;
0043 A280              ; --  in front of each cached block is a cache header.  in it are the vital
0044 A280              ; pieces of information that is needed to maintain the cache links.
0045 A280              ;
0046 A280              ; --  there are 2 classes of cached blocks, those that can be automatically
0047 A280              ; deleted from the cache list by LRU and those that can't.  the privileged
0048 A280              ; cached blocks are also known as deferred blocks.
0049 A280              ;
0050 A280              ; --  the cache list is doubly linked with a head virtual pointer and a tail
0051 A280              ; virtual pointer.  the head_vp always points to the most recently added or
0052 A280              ; requested block.  the tail_vp always points to the block that is least
0053 A280              ; recently used and that can be deleted because of LRU.  things get a little
0054 A280              ; complicated if the tail_vp points to a deferred block.
0055 A280              ;
0056 A280              ; --  incoming blocks are 'hashed' by 'and'ing away the block number and only
0057 A280              ; keeping the low 7 bits.  this will yield a max value of 127.  without looking
0058 A280              ; at disk structure, and assuming a fair amount of randomness in block number,
0059 A280              ; 'hashing' to one of 128 different values will generally yield a somewhat
0060 A280              ; even distribution.  these values are known here as buckets and the cache
0061 A280              ; list is also linked by bucket virtual pointers.  there are 128 different
0062 A280              ; bucket vps, there are no tail bucket vps.  also maintaining a linked list by
0063 A280              ; bucket vps gives the cache manager a very fast scheme of finding or deleting
0064 A280              ; a block.  (faster schemes were avoided because of the complexity implementing
0065 A280              ; and maintaining it.)
0066 A280              ;
0067 A280              ; --  when cash_flsh_def (flush deferred blocks) is called, the deferred blocks
0068 A280              ; are written to disk in the order they are found in the cache.  no, it doesn't
0069 A280              ; meet interleave and it maybe could if the deferred blocks were ordered
0070 A280              ; sequentially but it isn't that important here.  the cost in code, time and
0071 A280              ; maintaining it isn't worth one pass through the disk.  this call isn't used
0072 A280              ; that much and when it is used, no big deal if the heads move back and forth
0073 A280              ; a few times.
0074 A280              ;
0075 A280              ; --  the cache header contains a 2 byte reserved field that is currently used
0076 A280              ; to number the incoming block.  it can be used for other things if you want.
0077 A280              ;
0078 A280              ; --  there is some amount of memory that is used by the cache manager so the
0079 A280              ; user won't get 32K worth of cached blocks if he specified a 32K cache.  he'll
0080 A280              ; get about 29K depending on block size.  this is rather obscure but worth
0081 A280              ; mentioning and rather difficult to notice by the user.
0082 A280              ;
0083 A280              ; -- Jan 25, 1988  R.T.
0084 A280              ;
0085 A280              ;    Changed CASH_DEV_VOL.  The routine did not delete deferred blocks.  The
0086 A280              ;    routine now will delete both reqular blocks as well as deferred blocks.
0087 A280              ;    files changed:  'caching/scache1'
0088 A280              ;
0089 A280              ; -- Jan 26, 1988  R.T.
0090 A280              ;
0091 A280              ;    Changed CASH_DEV_VOL.  The routine will now tell the user that the volume
0092 A280              ;    may be damaged if a deferred block is deleted.
0093 A280              ;    files changed:  'caching/scache1' -> added a routine called 'show_message'
0094 A280              ;                    'caching/scache2' -> added 'message_shown' to data area
0095 A280              ;
0096 A280              ; -- Mar 22, 1988  R.T.
0097 A280              ;
0098 A280              ;    Changed CASH_DEL_VOL.  The routine will now delete ALL non-deferred
0099 A280              ;    blocks if both the device number and fst number are set to zero.
0100 A280              ;    The routine will now check the deferred bit when removing blocks by
0101 A280              ;    fst number.
0102 A280              ;    files changed:  'caching/scache1'
0103 A280              ;
0104 A280              ; -- Jan 30, 1989  R.T.
0105 A280              ;
0106 A280              ;    added auto_flush_handler:
0107 A280              ;               This routine will check to see if sessions are enabled.  If
0108 A280              ;               they are then I will issue a stop session call and then
0109 A280              ;               re-enable them.
0110 A280              ;
0111 A280              ; -- Feb 28, 1989  B.P.A
0112 A280              ;
0113 A280              ;    Changed cashseg_org from $a200 to $a280 to give SCM some more room to
0114 A280              ;    grow.  Added cache_overflow proc at end of code to check for code
0115 A280              ;    overflowing its space (will generate an error at link time).
0116 A280              ;
0117 A280              ; -- Mar 08, 1989  G.R.T
0118 A280              ;
0119 A280              ;    The Cache Manager now adds itself to the OutOfMemory Queue.  If I am
0120 A280              ;    called, I will do a reset_cache to the OS then return with the
0121 A280              ;    new bytes free count.
0122 A280              ;
0123 A280              ; -- Jun 05, 1989  G.R.T and B.P.A. and M.S.A
0124 A280              ;
0125 A280              ;     Fixed a bug in Cash_Del_Vol.  The routine was not doing a deref call
0126 A280              ;     for the bucket table.  This caused a problem if compact memory was
0127 A280              ;     called Vault.
0128 A280              ;
0129 A280              ; -- 9/14/89 Mensch and B.P.A.
0130 A280              ;
0131 A280              ;       Added a deref_bucket to the start of shutdown_cache in case the only cache
0132 A280              ;       block is that. This is to fix a reset_cache system death bug.
0133 A280              ;
0134 A280              ;
0135 A280              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
0136 A280              ; author: Ray (Rowdy Yates) Chiang
0137 A280              ;------------------------------------------------------------------------------
0138 A280              ;Revisions
0139 A280                       EXPORT cash_notes
0140 A280              cash_notes PROC 
0141 A280
0142 A280                       ENDP 
0143 A280
0144 A280              ;-----------------------------------------------------------------------------
0145 A280              ; Deref_bucket:
0146 A280              ;               This routine will deref the bucket table VP and setup
0147 A280              ;               cache_bkt_ptr
0148 A280              ;
0149 A280              ;
0150 A280              ;
0151 A280              ; inputs: A = don't care                outputs: A = trashed
0152 A280              ;         X = don't care                         X = trashed
0153 A280              ;         Y = don't care                         Y = trashed
0154 A280              ;         D = gs/os direct page                  D = i didn't change it
0155 A280              ;         B = don't care                         B = preserved
0156 A280              ;         K = don't care                         K = preserved
0157 A280              ;    LCbank = don't care                    LCbank = i didn't change it 
0158 A280              ;
0159 A280              ; Copyright (c) 1987,1988,1989 Apple Computer Inc. All rights reserved.
0160 A280              ; author: Rob Turner
0161 A280              ;-----------------------------------------------------------------------------
0162 A280
0163 A280              Deref_bucket proc 
0164 A280 08                    php   
0165 A281 DA                    phx   
0166 A282 5A                    phy   
0167 A283
0168 A283 AE C4 A9              ldx   bucket_vp
0169 A286 AC C6 A9              ldy   bucket_vp+2
0170 A289 22 38 FC 01           jsl   deref                    ;deref this for real pointing
0171 A28D 86 66                 stx   <cache_bkt_ptr
0172 A28F 84 68                 sty   <cache_bkt_ptr+2
0173 A291
0174 A291 7A                    ply   
0175 A292 FA                    plx   
0176 A293 28                    plp   
0177 A294
0178 A294 60                    rts   
0179 A295                       endp 
0180 A295
0181 A295              ;-----------------------------------------------------------------------------
0182 A295              ; curr_vp_to_ptr:
0183 A295              ;               This routine will set current_vp then deref current VP
0184 A295              ;               and store the result in cache_cur_ptr
0185 A295              ;
0186 A295              ;
0187 A295              ;
0188 A295              ; inputs: A = don't care                outputs: A = trashed
0189 A295              ;         X = vp low                             X = trashed
0190 A295              ;         Y = vp high                            Y = trashed
0191 A295              ;         D = gs/os direct page                  D = i didn't change it
0192 A295              ;         B = don't care                         B = preserved
0193 A295              ;         K = don't care                         K = preserved
0194 A295              ;    LCbank = don't care                    LCbank = i didn't change it 
0195 A295              ;
0196 A295              ; Copyright (c) 1987,1988,1989 Apple Computer Inc. All rights reserved.
0197 A295              ; author: Rob Turner
0198 A295              ;-----------------------------------------------------------------------------
0199 A295
0200 A295              curr_vp_to_ptr proc 
0201 A295 8E B8 A9              stx   current_vp
0202 A298 8C BA A9              sty   current_vp+2
0203 A29B                       export XY_to_cur_ptr
0204 A29B              XY_to_cur_ptr  
0205 A29B 22 38 FC 01           jsl   deref
0206 A29F 86 5A                 stx   <cache_cur_ptr
0207 A2A1 84 5C                 sty   <cache_cur_ptr+2
0208 A2A3 60                    rts   
0209 A2A4                       endp 
0210 A2A4
0211 A2A4              ;-----------------------------------------------------------------------------
0212 A2A4              ; auto_flush_handler:
0213 A2A4              ;               This routine will check to see if sessions are enabled.  If
0214 A2A4              ;               they are then I will issue a stop session call and then
0215 A2A4              ;               re-enable them.
0216 A2A4              ;
0217 A2A4              ;
0218 A2A4              ;
0219 A2A4              ; inputs: A = don't care                outputs: A = trashed
0220 A2A4              ;         X = don't care                         X = trashed
0221 A2A4              ;         Y = don't care                         Y = trashed
0222 A2A4              ;         D = gs/os direct page                  D = i didn't change it
0223 A2A4              ;         B = don't care                         B = preserved
0224 A2A4              ;         K = don't care                         K = preserved
0225 A2A4              ;    LCbank = don't care                    LCbank = i didn't change it 
0226 A2A4              ;
0227 A2A4              ; Copyright (c) 1987,1988,1989 Apple Computer Inc. All rights reserved.
0228 A2A4              ; author: Rob Turner
0229 A2A4              ;-----------------------------------------------------------------------------
0230 A2A4
0231 A2A4              auto_flush_handler proc  
0232 A2A4                       import in_queue
0233 A2A4
0234 A2A4 4B                    phk   
0235 A2A5 AB                    plb   
0236 A2A6
0237 A2A6 22 A8 00 E1           jsl   $e100a8
0238 A2AA 1F 20                 DC W:$201f                     ;get the current sessions flag
0239 A2AC D0 A2 00 00           DC L:get_session
0240 A2B0
0241 A2B0 AD D2 A2              lda   session_state
0242 A2B3 29 01 00              and   #$0001                   ;clear all other bits
0243 A2B6 F0 14                 beq   @no_sessions
0244 A2B8
0245 A2B8 22 A8 00 E1           jsl   $e100a8                  ;now do a stop session call please
0246 A2BC 1E 20                 DC W:$201E
0247 A2BE D4 A2 00 00           DC L:session_list
0248 A2C2
0249 A2C2 22 A8 00 E1           jsl   $e100a8
0250 A2C6 1D 20                 DC W:$201d                     ;turn the session back on please
0251 A2C8 D4 A2 00 00           DC L:session_list
0252 A2CC
0253 A2CC              @no_sessions  
0254 A2CC 9C E2 A9              stz   in_queue                 ;indicate that we have ran
0255 A2CF 6B                    rtl   
0256 A2D0
0257 A2D0 01 00        get_session DC W:$01                    ;PCount
0258 A2D2 00 00        session_state DC W:00
0259 A2D4
0260 A2D4 00 00        session_list DC W:$0000
0261 A2D6
0262 A2D6                       endp 
0263 A2D6
0264 A2D6              ;-----------------------------------------------------------------------------
0265 A2D6              ; CASH_INIT -- initializes the cache
0266 A2D6              ;
0267 A2D6              ; This routine will try to initialize the cache.  Memory as needed by the
0268 A2D6              ; cache is obtained from the Mike Memory Manager.  The size of the cache is
0269 A2D6              ; determined by looking at battery ram.  Once this is read, changing the
0270 A2D6              ; value in battery ram will not change the size of the cache.  The cache size
0271 A2D6              ; cannot be changed on the fly unless you're SSSPECIAL !!!
0272 A2D6              ;
0273 A2D6              ; Input and output is passed to this routine by GS/OS direct page and full
0274 A2D6              ; native mode is always assumed.
0275 A2D6              ;
0276 A2D6              ; inputs: A = don't care                outputs: A = trashed
0277 A2D6              ;         X = don't care                         X = trashed
0278 A2D6              ;         Y = don't care                         Y = trashed
0279 A2D6              ;         D = gs/os direct page                  D = i didn't change it
0280 A2D6              ;         B = don't care                         B = preserved
0281 A2D6              ;         K = don't care                         K = preserved
0282 A2D6              ;    LCbank = don't care                    LCbank = i didn't change it 
0283 A2D6              ;
0284 A2D6              ; on output: c = 0 means no error, the block is cached
0285 A2D6              ;            c = 1 means something screwed up, the block's not cached
0286 A2D6              ;
0287 A2D6              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
0288 A2D6              ; author: Ray (Rowdy Yates) Chiang
0289 A2D6              ;-----------------------------------------------------------------------------
0290 A2D6
0291 A2D6                       EXPORT cash_init
0292 A2D6              cash_init PROC 
0293 A2D6                       import c_data_len
0294 A2D6
0295 A2D6 8B                    phb                            ;save caller's data bank
0296 A2D7 4B                    phk   
0297 A2D8 AB                    plb                            ;set data bank to ourspace
0298 A2D9
0299 A2D9 A2 33 00              ldx   #c_data_len              ;number of bytes to zero
0300 A2DC 9E B0 A9     cash_i00 stz   start_of_data,x
0301 A2DF CA                    dex   
0302 A2E0 CA                    dex   
0303 A2E1 10 F9                 bpl   cash_i00
0304 A2E3
0305 A2E3              ;-----------------------------------------------------------------------------
0306 A2E3              ; we need a segment of memory for holding the bucket vps.  since there will be
0307 A2E3              ; 128 buckets and each bucket will contain a bucket vp, the memory request
0308 A2E3              ; will be 512 bytes.
0309 A2E3              ;-----------------------------------------------------------------------------
0310 A2E3
0311 A2E3 A9 00 02              lda   #$0200                   ;size of request, in bytes
0312 A2E6 8D CC A9              sta   c_request_size           ;save this for later
0313 A2E9 38                    sec                            ;we want it zeroed
0314 A2EA 22 1C FC 01           jsl   alloc_seg                ;try to get it from mr. mike
0315 A2EE 90 03                 bcc   cash_i01                 ;skip if no problem
0316 A2F0 4C 11 A9              jmp   cache_error              ;damn, couldn't get memory
0317 A2F3
0318 A2F3 8E C4 A9     cash_i01 stx   bucket_vp
0319 A2F6 8C C6 A9              sty   bucket_vp+2              ;save vp to bucket array
0320 A2F9
0321 A2F9              ;-----------------------------------------------------------------------------
0322 A2F9              ; read battery ram to find the user selected cache size.  each tick equals
0323 A2F9              ; 32K. (max size = 4M - 32K)  normal battery ram is $ff, if the value read
0324 A2F9              ; is $ff then we'll pretend it's a 1.  if the value read is 0, then the
0325 A2F9              ; ram cache size will be about 16K, enough to boot, not much more.
0326 A2F9              ;-----------------------------------------------------------------------------
0327 A2F9
0328 A2F9 F4 00 00              pea   $0000                    ;push space for result
0329 A2FC F4 81 00              pea   ram_cache_size           ;location of cache size
0330 A2FF A2 03 0C              ldx   #$0c03                   ;read battery parameter
0331 A302 22 00 00 E1           jsl   $e10000                  ;ain't no error possible
0332 A306 68                    pla                            ;get cache size, low only
0333 A307 29 FF 00              and   #$00ff                   ;make sure to only keep low byte
0334 A30A F0 14                 beq   cash_i02                 ;skip if 0, user wants no cache
0335 A30C C9 FF 00              cmp   #$00ff
0336 A30F F0 14                 beq   cash_i03                 ;skip if $ff, pretend it's 1
0337 A311 18                    clc   
0338 A312 6A                    ror   a
0339 A313 90 06                 bcc   cash_i01a                ;skip if c = 0, even number of 32Ks
0340 A315 A2 80 00              ldx   #$0080                   ;32K
0341 A318 8E C9 A9              stx   c_bytes_free+1           ;take care of odd
0342 A31B
0343 A31B 8D CA A9     cash_i01a sta   c_bytes_free+2          ;take care of even
0344 A31E 80 0B                 bra   cash_i05
0345 A320
0346 A320 A9 40 00     cash_i02 lda   #default_cache_size
0347 A323 80 03                 bra   cash_i04
0348 A325
0349 A325 A9 80 00     cash_i03 lda   #$0080                   	;32K
0350 A328 8D C9 A9     cash_i04 sta   c_bytes_free+1           ;size of total cache in bytes
0351 A32B
0352 A32B              ; subtract bucket array size from total bytes free
0353 A32B
0354 A32B 4C 9B A3     cash_i05 jmp   update_free
0355 A32E
0356 A32E                       ENDP 
0357 A32E              ;-----------------------------------------------------------------------------
0358 A32E              ; CASH_ADD -- adds a block to the cache
0359 A32E              ;
0360 A32E              ; This routine will try to add the requested block into the cache.  It's
0361 A32E              ; position within the LRU and bucket chain will be at the start of the list.
0362 A32E              ; In the event there is not enough room in the cache, the last recently used
0363 A32E              ; block(s) will be purged until there is enough room for the requested block.
0364 A32E              ;
0365 A32E              ; Input and output is passed to this routine by GS/OS direct page and full
0366 A32E              ; native mode is always assumed.
0367 A32E              ;
0368 A32E              ; inputs: A = don't care                outputs: A = trashed
0369 A32E              ;         X = don't care                         X = trashed
0370 A32E              ;         Y = don't care                         Y = trashed
0371 A32E              ;         D = gs/os direct page                  D = i didn't change it
0372 A32E              ;         B = don't care                         B = preserved
0373 A32E              ;         K = don't care                         K = preserved
0374 A32E              ;    LCbank = don't care                    LCbank = i didn't change it 
0375 A32E              ;
0376 A32E              ; on output: c = 0 means no error, the block is cached
0377 A32E              ;            c = 1 means something screwed up, the block's not cached
0378 A32E              ;
0379 A32E              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
0380 A32E              ; author: Ray (Rowdy Yates) Chiang
0381 A32E              ;-----------------------------------------------------------------------------
0382 A32E
0383 A32E                       EXPORT cash_add
0384 A32E              cash_add PROC 
0385 A32E                                                      ;using   common_equ
0386 A32E                                                      ;using   cache_data
0387 A32E
0388 A32E 8B                    phb                            ;save caller's data bank
0389 A32F 4B                    phk   
0390 A330 AB                    plb                            ;set data bank to ourspace
0391 A331 20 80 A2              jsr   deref_bucket             ;Deref the bucket table and setup cache_bkt_ptr
0392 A334
0393 A334              ; always assume it ain't there, but see if there's enough room first
0394 A334
0395 A334 18           cash_a00 clc   
0396 A335 A5 14                 lda   <drvr_blk_size           ;get requested block size
0397 A337 69 24 00              adc   #c_headerlen             ;add to size of cache header
0398 A33A 8D CC A9              sta   c_request_size           ;save this for later
0399 A33D 20 81 A6              jsr   enuf_room                ;check for space free
0400 A340 90 02                 bcc   cash_a01                 ;skip if there's room for it
0401 A342 80 09                 bra   cash_a02                 ;something's wrong
0402 A344
0403 A344 AD CC A9     cash_a01 lda   c_request_size           ;get the size we want
0404 A347              ;        clc                            ;we don't want it zeroed
0405 A347 22 1C FC 01           jsl   alloc_seg                ;ask for this amount from mike
0406 A34B 90 03                 bcc   cash_a03                 ;skip if we got it
0407 A34D 4C 11 A9     cash_a02 jmp   cache_error              ;damn! couldn't get the memory
0408 A350
0409 A350              ; add this cache cell to the start of the LRU chain
0410 A350
0411 A350 20 B3 A6     cash_a03 jsr   addme2lru
0412 A353
0413 A353              ; add this cache cell to the start of the bucket chain
0414 A353
0415 A353 20 18 A7              jsr   add2bktlist
0416 A356 B0 F5                 bcs   cash_a02                 ;error from mike
0417 A358
0418 A358              ; now fill in the rest of the cache header information
0419 A358
0420 A358 A0 10 00              ldy   #c_blknum                ;point to block number, lo
0421 A35B A5 10                 lda   <drvr_blk_num
0422 A35D 97 5A                 sta   [<cache_cur_ptr],y
0423 A35F C8                    iny   
0424 A360 C8                    iny                            ;point to block number, hi
0425 A361 A5 12                 lda   <drvr_blk_num+2
0426 A363 97 5A                 sta   [<cache_cur_ptr],y
0427 A365
0428 A365 C8                    iny   
0429 A366 C8                    iny                            ;point to block size
0430 A367 A5 14                 lda   <drvr_blk_size
0431 A369 97 5A                 sta   [<cache_cur_ptr],y
0432 A36B
0433 A36B C8                    iny   
0434 A36C C8                    iny                            ;point to FST number
0435 A36D A5 16                 lda   <drvr_fst_num
0436 A36F 97 5A                 sta   [<cache_cur_ptr],y
0437 A371
0438 A371 C8                    iny   
0439 A372 C8                    iny                            ;point to volume id
0440 A373 A5 18                 lda   <drvr_vol_id
0441 A375 97 5A                 sta   [<cache_cur_ptr],y
0442 A377
0443 A377 C8                    iny   
0444 A378 C8                    iny                            ;point to device number
0445 A379 A5 00                 lda   <drvr_dev_num
0446 A37B 97 5A                 sta   [<cache_cur_ptr],y
0447 A37D
0448 A37D C8                    iny   
0449 A37E C8                    iny                            ;point to cache priority
0450 A37F A5 1A                 lda   <drvr_cache
0451 A381 97 5A                 sta   [<cache_cur_ptr],y
0452 A383
0453 A383 C8                    iny   
0454 A384 C8                    iny                            ;point to cell size
0455 A385 AD CC A9              lda   c_request_size
0456 A388 97 5A                 sta   [<cache_cur_ptr],y
0457 A38A
0458 A38A              ; the following is only for debugging purposes . . .
0459 A38A
0460 A38A C8                    iny   
0461 A38B C8                    iny                            ;point to reserved field
0462 A38C EE DC A9              inc   c_marker
0463 A38F AD DC A9              lda   c_marker
0464 A392 97 5A                 sta   [<cache_cur_ptr],y
0465 A394 C8                    iny   
0466 A395 C8                    iny   
0467 A396 97 5A                 sta   [<cache_cur_ptr],y
0468 A398
0469 A398 20 B0 A8              jsr   set_cache_ptr            ;set drvr_cach_ptr before returning
0470 A39B
0471 A39B              ; update bytes free and we're done.
0472 A39B
0473 A39B                       EXPORT update_free
0474 A39B              update_free                             ;               
0475 A39B 38                    sec   
0476 A39C AD C8 A9              lda   c_bytes_free
0477 A39F ED CC A9              sbc   c_request_size
0478 A3A2 8D C8 A9              sta   c_bytes_free
0479 A3A5
0480 A3A5 AD CA A9              lda   c_bytes_free+2
0481 A3A8 E9 00 00              sbc   #$0000
0482 A3AB 8D CA A9              sta   c_bytes_free+2           ;4 byte subtract
0483 A3AE
0484 A3AE AB                    plb   
0485 A3AF 18                    clc   
0486 A3B0 6B                    rtl   
0487 A3B1
0488 A3B1                       ENDP 
0489 A3B1              ;-----------------------------------------------------------------------------
0490 A3B1              ; CASH_FIND -- finds a block in the cache
0491 A3B1              ;
0492 A3B1              ; This routine will try to find the requested block in the cache.  If it's
0493 A3B1              ; found, it'll be moved to the start of the LRU chain and a 4 byte pointer will
0494 A3B1              ; be returned pointing to the start of the requested block.  The bucket links
0495 A3B1              ; will not be moved.
0496 A3B1              ;
0497 A3B1              ; Input and output is passed to this routine by GS/OS direct page and full
0498 A3B1              ; native mode is always assumed.
0499 A3B1              ;
0500 A3B1              ; on input: c = 0 means look for the block
0501 A3B1              ;           c = 1 means look for vol_id and deferred bit
0502 A3B1              ;
0503 A3B1              ; inputs: A = vol_id if c=1             outputs: A = trashed
0504 A3B1              ;         X = don't care                         X = trashed
0505 A3B1              ;         Y = don't care                         Y = trashed
0506 A3B1              ;         D = gs/os direct page                  D = i didn't change it
0507 A3B1              ;         B = don't care                         B = preserved
0508 A3B1              ;         K = don't care                         K = preserved
0509 A3B1              ;    LCbank = don't care                    LCbank = i didn't change it 
0510 A3B1              ;
0511 A3B1              ; on output: c = 0 means no error, the block is in the cache or vol_id found
0512 A3B1              ;            c = 1 means something screwed up or the block's not in the cache
0513 A3B1              ;                  or vol_id not found
0514 A3B1              ;
0515 A3B1              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
0516 A3B1              ; author: Ray (Rowdy Yates) Chiang
0517 A3B1              ;-----------------------------------------------------------------------------
0518 A3B1
0519 A3B1                       EXPORT cash_find
0520 A3B1              cash_find PROC 
0521 A3B1                                                      ;using   common_equ
0522 A3B1                                                      ;using   cache_data
0523 A3B1
0524 A3B1 8B                    phb                            ;save caller's data bank
0525 A3B2 4B                    phk   
0526 A3B3 AB                    plb                            ;set data bank to ourspace
0527 A3B4
0528 A3B4 90 05                 bcc   cash_fff                 ;skip if we're looking for a block
0529 A3B6 20 B7 A7              jsr   search_vol_id            ;we're looking for vol_id
0530 A3B9 AB                    plb                            ;pull to balance the stack
0531 A3BA 6B                    rtl                            ;result in c
0532 A3BB
0533 A3BB              ; if we came from cash_flsh_def then we want to skip this
0534 A3BB
0535 A3BB AE DE A9     cash_fff ldx   no_find                  ;non 0 means we want to skip this
0536 A3BE D0 05                 bne   cash_fff0
0537 A3C0 20 71 A7              jsr   cache_search             ;locate the requested block
0538 A3C3 90 03                 bcc   cash_fm00                ;skip if we found it
0539 A3C5 4C 11 A9     cash_fff0 jmp   cache_error             ;error, no can find
0540 A3C8
0541 A3C8              ; if we're in deferred mode and the block ain't, then correct for this
0542 A3C8
0543 A3C8 A0 1C 00     cash_fm00 ldy   #c_priority             ;offset to priority field
0544 A3CB B7 5A                 lda   [<cache_cur_ptr],y
0545 A3CD AA                    tax                            ;save for later
0546 A3CE 30 11                 bmi   cash_f00                 ;skip if deferred bit set
0547 A3D0 A5 1A                 lda   <drvr_cache              ;are we deferred mode now ?
0548 A3D2 10 0D                 bpl   cash_f00                 ;skip if no
0549 A3D4 8A                    txa                            ;bring a back
0550 A3D5 09 00 80              ora   #$8000                   ;make this block deferred
0551 A3D8 97 5A                 sta   [<cache_cur_ptr],y       ;this guy's deferred
0552 A3DA
0553 A3DA A5 18                 lda   <drvr_vol_id
0554 A3DC A0 18 00              ldy   #c_volumeid
0555 A3DF 97 5A                 sta   [<cache_cur_ptr],y
0556 A3E1
0557 A3E1              ; pull out both LRU links into next_vp and prev_vp
0558 A3E1
0559 A3E1 A2 04 00     cash_f00 ldx   #c_lru_bwd
0560 A3E4 A0 00 00              ldy   #c_lru_fwd
0561 A3E7 20 F1 A7              jsr   getlinks                 ;prev_vp in x and y
0562 A3EA
0563 A3EA 98                    tya   
0564 A3EB D0 05                 bne   cash_f01                 ;skip if hi backlink <> 0
0565 A3ED 8A                    txa   
0566 A3EE D0 02                 bne   cash_f01                 ;skip if lo backlink <> 0
0567 A3F0
0568 A3F0              ; backlink = 0, cache cell is at the start of list, ain't much left to do
0569 A3F0
0570 A3F0 80 2A                 bra   cash_f04
0571 A3F2
0572 A3F2              ; backlink <> 0, check forward link to see if cache cell is at the end
0573 A3F2
0574 A3F2 AD BC A9     cash_f01 lda   next_vp
0575 A3F5 D0 13                 bne   cash_f02                 ;skip if hi forward link <> 0
0576 A3F7 AD BE A9              lda   next_vp+2
0577 A3FA D0 0E                 bne   cash_f02                 ;skip if hi forward link <> 0
0578 A3FC
0579 A3FC              ; forward link = 0, cache cell is at end of list, update tail_vp
0580 A3FC              ; prev_vp is still in x and y
0581 A3FC
0582 A3FC 8E B4 A9              stx   tail_vp
0583 A3FF 8C B6 A9              sty   tail_vp+2
0584 A402 A9 00 00              lda   #c_lru_fwd
0585 A405 20 0D A8              jsr   set_flink_2nil           ;set forward link to nil
0586 A408 80 09                 bra   cash_f03
0587 A40A
0588 A40A              ; backlink and forward link are both <> 0, the cache cell is somewhere in
0589 A40A              ; the middle of the list.  the head_vp and tail_vp aren't used here.  unlink
0590 A40A              ; the LRU links of the current cell by joining the previous and next cells
0591 A40A              ; together.
0592 A40A
0593 A40A A2 04 00     cash_f02 ldx   #c_lru_bwd
0594 A40D A0 00 00              ldy   #c_lru_fwd
0595 A410 20 25 A8              jsr   unlink
0596 A413
0597 A413              ; the current cache cell has been LRU unlinked.  reattach the LRU links at
0598 A413              ; the start of the LRU chain.
0599 A413
0600 A413 AE B8 A9     cash_f03 ldx   current_vp
0601 A416 AC BA A9              ldy   current_vp+2
0602 A419 20 B3 A6              jsr   addme2lru
0603 A41C
0604 A41C              ; last thing to do is return the pointer to the cached block
0605 A41C
0606 A41C 20 B0 A8     cash_f04 jsr   set_cache_ptr            ;set drvr_cach_ptr before returning
0607 A41F
0608 A41F AB           cash_f05 plb                            ;restore caller's data bank
0609 A420 18                    clc                            ;indicate no error
0610 A421 6B                    rtl   
0611 A422                       ENDP 
0612 A422
0613 A422              ;-----------------------------------------------------------------------------
0614 A422              ; CASH_DELETE -- deletes (purges) a block from the cache
0615 A422              ;
0616 A422              ; This routine will try to delete the requested block from the cache.  If
0617 A422              ; entry to this routine is via cache_xdelete then we don't have to look for
0618 A422              ; the block before deleting it, the block is pointed to by current_vp.
0619 A422              ;
0620 A422              ; Input and output is passed to this routine by GS/OS direct page and full
0621 A422              ; native mode is always assumed.
0622 A422              ;
0623 A422              ; inputs: A = don't care                outputs: A = trashed
0624 A422              ;         X = don't care                         X = trashed
0625 A422              ;         Y = don't care                         Y = trashed
0626 A422              ;         D = gs/os direct page                  D = i didn't change it
0627 A422              ;         B = don't care                         B = preserved
0628 A422              ;         K = don't care                         K = preserved
0629 A422              ;    LCbank = don't care                    LCbank = i didn't change it 
0630 A422              ;
0631 A422              ; on output: c = 0 means no error, the block has been deleted from the cache
0632 A422              ;            c = 1 means something screwed up or the block's not in the cache
0633 A422              ;
0634 A422              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
0635 A422              ; author: Ray (Rowdy Yates) Chiang
0636 A422              ;-----------------------------------------------------------------------------
0637 A422
0638 A422                       EXPORT cash_delete
0639 A422              cash_delete PROC 
0640 A422                                                      ;using   common_equ
0641 A422                                                      ;using   cache_data
0642 A422
0643 A422 8B                    phb                            ;save caller's data bank
0644 A423 4B                    phk   
0645 A424 AB                    plb                            ;set data bank to ourspace
0646 A425 80 05                 bra   cash_dxxx                ;skip over other entry point
0647 A427
0648 A427                       EXPORT cache_xdelete
0649 A427              cache_xdelete                           ;               
0650 A427 8B                    phb                            ;save caller's data bank
0651 A428 4B                    phk   
0652 A429 AB                    plb                            ;set data bank to ourspace
0653 A42A 80 08                 bra   cash_d00                 ;jump into it
0654 A42C
0655 A42C 20 71 A7     cash_dxxx jsr   cache_search            ;locate the requested block
0656 A42F 90 03                 bcc   cash_d00                 ;skip if we found it
0657 A431 4C 11 A9              jmp   cache_error              ;error, no can find
0658 A434
0659 A434              ;-----------------------------------------------------------------------------
0660 A434              ; remove this cache cell from the LRU chain
0661 A434              ;-----------------------------------------------------------------------------
0662 A434
0663 A434              ; pull out both LRU links into next_vp and prev_vp, we'll need them later
0664 A434
0665 A434 A2 04 00     cash_d00 ldx   #c_lru_bwd
0666 A437 A0 00 00              ldy   #c_lru_fwd
0667 A43A 20 F1 A7              jsr   getlinks                 ;prev_vp in x and y
0668 A43D
0669 A43D              ; if we happen to come in from xdelete, then we need to keep around the value
0670 A43D              ; of next_vp.  removing by bucket will destroy this.
0671 A43D
0672 A43D AD BC A9              lda   next_vp
0673 A440 8D D8 A9              sta   c_temp_nvp
0674 A443 AD BE A9              lda   next_vp+2
0675 A446 8D DA A9              sta   c_temp_nvp+2
0676 A449
0677 A449 98                    tya   
0678 A44A D0 33                 bne   cash_d02                 ;skip if hi backlink <> 0
0679 A44C 8A                    txa   
0680 A44D D0 30                 bne   cash_d02                 ;skip if lo backlink <> 0
0681 A44F
0682 A44F              ; backlink = 0, cache cell is at the start of list.  if forward link = 0 then
0683 A44F              ; we have a single cell cache.  x is still 0.
0684 A44F
0685 A44F EC BC A9              cpx   next_vp
0686 A452 D0 14                 bne   cash_d01                 ;skip if lo forward link <> 0
0687 A454 EC BE A9              cpx   next_vp+2
0688 A457 D0 0F                 bne   cash_d01                 ;skip if hi forward link <> 0
0689 A459
0690 A459              ; forward link is also = 0, we have a single cell cache.
0691 A459
0692 A459 9C B0 A9              stz   head_vp                  ;x is 0 from above
0693 A45C 9C B2 A9              stz   head_vp+2
0694 A45F 9C B4 A9              stz   tail_vp
0695 A462 9C B6 A9              stz   tail_vp+2
0696 A465 4C B9 A4              jmp   cash_dd00a
0697 A468
0698 A468              ; forward link is not = 0, but the backlink is still = 0
0699 A468
0700 A468 AE BC A9     cash_d01 ldx   next_vp
0701 A46B 8E B0 A9              stx   head_vp
0702 A46E AE BE A9              ldx   next_vp+2
0703 A471 8E B2 A9              stx   head_vp+2                ;head_vp now points to 2nd cell
0704 A474
0705 A474 A2 04 00              ldx   #c_lru_bwd
0706 A477 8E D2 A9              stx   c_temp_bwd
0707 A47A 20 48 A8              jsr   unlink_bwd               ;unlink backward link
0708 A47D 80 21                 bra   cash_dd00
0709 A47F
0710 A47F              ; backlink <> 0, check forward link to see if cache cell is at the end
0711 A47F
0712 A47F AD BC A9     cash_d02 lda   next_vp
0713 A482 D0 13                 bne   cash_d03                 ;skip if lo forward link <> 0
0714 A484 AD BE A9              lda   next_vp+2
0715 A487 D0 0E                 bne   cash_d03                 ;skip if hi forward link <> 0
0716 A489
0717 A489              ; forward link = 0, cache cell is at end of list.  prev_vp is still in x and y
0718 A489
0719 A489 8E B4 A9              stx   tail_vp
0720 A48C 8C B6 A9              sty   tail_vp+2                ;tail_vp now points to 2nd from last
0721 A48F
0722 A48F A9 00 00              lda   #c_lru_fwd
0723 A492 20 0D A8              jsr   set_flink_2nil           ;set forward link to nil
0724 A495 80 09                 bra   cash_dd00
0725 A497
0726 A497              ; backlink and forward link are both <> 0, the cache cell is somewhere in
0727 A497              ; the middle of the list.  the head_vp and tail_vp aren't used here.  unlink
0728 A497              ; the LRU links of the current cell by joining the previous and next cells
0729 A497              ; together.
0730 A497
0731 A497 A2 04 00     cash_d03 ldx   #c_lru_bwd
0732 A49A A0 00 00              ldy   #c_lru_fwd
0733 A49D 20 25 A8              jsr   unlink
0734 A4A0
0735 A4A0              ; the current cache cell has been LRU unlinked.
0736 A4A0
0737 A4A0              ;-----------------------------------------------------------------------------
0738 A4A0              ; remove this cache cell from the bucket chain
0739 A4A0              ;-----------------------------------------------------------------------------
0740 A4A0
0741 A4A0              ; pull out both bucket links into next_vp and prev_vp, we'll need them later
0742 A4A0
0743 A4A0 A2 0C 00     cash_dd00 ldx   #c_bkt_bwd
0744 A4A3 A0 08 00              ldy   #c_bkt_fwd
0745 A4A6 20 F1 A7              jsr   getlinks                 ;prev_vp in x and y
0746 A4A9
0747 A4A9 98                    tya   
0748 A4AA D0 43                 bne   cash_dd01                ;skip if hi backlink <> 0
0749 A4AC 8A                    txa   
0750 A4AD D0 40                 bne   cash_dd01                ;skip if lo backlink <> 0
0751 A4AF
0752 A4AF              ; backlink = 0, cache cell is at the start of list.  if forward link = 0 then
0753 A4AF              ; we have a single cell cache.  x is still 0.
0754 A4AF
0755 A4AF EC BC A9              cpx   next_vp
0756 A4B2 D0 19                 bne   cash_dd00b               ;skip if lo forward link <> 0
0757 A4B4 EC BE A9              cpx   next_vp+2
0758 A4B7 D0 14                 bne   cash_dd00b               ;skip if hi forward link <> 0
0759 A4B9
0760 A4B9              ; forward link is also = 0, we have a single cell bucket list
0761 A4B9
0762 A4B9 A0 10 00     cash_dd00a ldy   #c_blknum
0763 A4BC B7 5A                 lda   [<cache_cur_ptr],y       ;get block number, lo
0764 A4BE 29 7F 00              and   #$007f                   ;keep low 7 bits
0765 A4C1 0A                    asl   a
0766 A4C2 0A                    asl   a                        ;multiply by 4 to make into index
0767 A4C3 A8                    tay   
0768 A4C4 8A                    txa                            ;set acc to 0
0769 A4C5 97 66                 sta   [<cache_bkt_ptr],y
0770 A4C7 C8                    iny   
0771 A4C8 C8                    iny   
0772 A4C9 97 66                 sta   [<cache_bkt_ptr],y
0773 A4CB 80 3D                 bra   cash_dd03                ;we done
0774 A4CD
0775 A4CD              ; forward link is not = 0, but backlink is still = 0
0776 A4CD
0777 A4CD A0 10 00     cash_dd00b ldy   #c_blknum
0778 A4D0 B7 5A                 lda   [<cache_cur_ptr],y       ;get block number, lo
0779 A4D2 29 7F 00              and   #$007f                   ;keep low 7 bits
0780 A4D5 0A                    asl   a
0781 A4D6 0A                    asl   a                        ;multiply by 4 to make into index
0782 A4D7 A8                    tay   
0783 A4D8 AD BC A9              lda   next_vp
0784 A4DB 97 66                 sta   [<cache_bkt_ptr],y
0785 A4DD C8                    iny   
0786 A4DE C8                    iny   
0787 A4DF AD BE A9              lda   next_vp+2
0788 A4E2 97 66                 sta   [<cache_bkt_ptr],y
0789 A4E4
0790 A4E4 A2 0C 00              ldx   #c_bkt_bwd
0791 A4E7 8E D2 A9              stx   c_temp_bwd
0792 A4EA 20 48 A8              jsr   unlink_bwd               ;unlink backward link
0793 A4ED 80 1B                 bra   cash_dd03
0794 A4EF
0795 A4EF              ; backlink <> 0, check forward link to see if cache cell is at the end
0796 A4EF
0797 A4EF AD BC A9     cash_dd01 lda   next_vp
0798 A4F2 D0 0D                 bne   cash_dd02                ;skip if hi forward link <> 0
0799 A4F4 AD BE A9              lda   next_vp+2
0800 A4F7 D0 08                 bne   cash_dd02                ;skip if hi forward link <> 0
0801 A4F9
0802 A4F9              ; forward link = 0, cache cell is at end of list.  prev_vp is still in x and y
0803 A4F9
0804 A4F9 A9 08 00              lda   #c_bkt_fwd
0805 A4FC 20 0D A8              jsr   set_flink_2nil           ;set forward link to nil
0806 A4FF 80 09                 bra   cash_dd03
0807 A501
0808 A501              ; backlink and forward link are both <> 0, the cache cell is somewhere in
0809 A501              ; the middle of the list.  unlink the bucket links of the current cell by
0810 A501              ; joining the previous and next cells together.
0811 A501
0812 A501 A2 0C 00     cash_dd02 ldx   #c_bkt_bwd
0813 A504 A0 08 00              ldy   #c_bkt_fwd
0814 A507 20 25 A8              jsr   unlink
0815 A50A
0816 A50A              ; the current cache cell has been bucket unlinked.  now give it back to mike.
0817 A50A              ; also, update the free byte count
0818 A50A
0819 A50A 20 9E A8     cash_dd03 jsr   add_to_free             ;add this amount to free byte count
0820 A50D
0821 A50D AE B8 A9              ldx   current_vp
0822 A510 AC BA A9              ldy   current_vp+2
0823 A513 22 20 FC 01           jsl   release_seg              ;try to give it back to mike
0824 A517 90 03                 bcc   cash_dd04                ;skip if no problem
0825 A519 4C 11 A9              jmp   cache_error              ;damn, couldn't give it back
0826 A51C
0827 A51C AB           cash_dd04 plb                           ;restore caller's data bank
0828 A51D 18                    clc                            ;indicate no error
0829 A51E 6B                    rtl   
0830 A51F                       ENDP 
0831 A51F
0832 A51F              ;-----------------------------------------------------------------------------
0833 A51F              ; CASH_DEL_VOL -- deletes (purges) a volume's block(s) from the cache
0834 A51F              ;
0835 A51F              ; This routine will try to delete all blocks belonging to the requested
0836 A51F              ; device number from the cache.  If the device number = 0 then all blocks
0837 A51F              ; of all device numbers of the specified FST will be deleted.  If both
0838 A51F              ; device number and fst number are zero all blocks that are not deferred
0839 A51F              ; will be deleted.
0840 A51F              ;
0841 A51F              ; Input and output is passed to this routine by GS/OS direct page and full
0842 A51F              ; native mode is always assumed.
0843 A51F              ;
0844 A51F              ; inputs: A = don't care                outputs: A = trashed
0845 A51F              ;         X = don't care                         X = trashed
0846 A51F              ;         Y = don't care                         Y = trashed
0847 A51F              ;         D = gs/os direct page                  D = i didn't change it
0848 A51F              ;         B = don't care                         B = preserved
0849 A51F              ;         K = don't care                         K = preserved
0850 A51F              ;    LCbank = don't care                    LCbank = i didn't change it 
0851 A51F              ;
0852 A51F              ; on output: c = 0 means no error, the volume's block(s) are deleted
0853 A51F              ;            c = 1 means something screwed up, the blocks may still be cached
0854 A51F              ;
0855 A51F              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
0856 A51F              ; author: Ray (Rowdy Yates) Chiang
0857 A51F              ;-----------------------------------------------------------------------------
0858 A51F
0859 A51F                       EXPORT cash_del_vol
0860 A51F              cash_del_vol PROC 
0861 A51F                                                      ;using   common_equ
0862 A51F                                                      ;using   cache_data
0863 A51F
0864 A51F 8B                    phb                            ;save caller's data bank
0865 A520 4B                    phk   
0866 A521 AB                    plb                            ;set data bank to ourspace
0867 A522
0868 A522 20 80 A2              jsr   deref_bucket             ;Deref the bucket table and setup cache_bkt_ptr
0869 A525
0870 A525 9C E0 A9              stz   message_shown            ;reset flag. Flag used to tell user
0871 A528                                                      ;that a deferred block has been flushed
0872 A528
0873 A528 A4 00                 ldy   <drvr_dev_num
0874 A52A 8C D6 A9              sty   c_temp_2                 ;assume we're deleting by device number
0875 A52D
0876 A52D A4 16                 ldy   <drvr_fst_num
0877 A52F A2 1A 00              ldx   #c_devnum
0878 A532 A5 00                 lda   <drvr_dev_num
0879 A534 D0 06                 bne   cash_dv00                ;skip if we're deleting by device #
0880 A536 8C D6 A9              sty   c_temp_2                 ;        we're deleting by FST
0881 A539 A2 16 00              ldx   #c_fstnum
0882 A53C 8E D4 A9     cash_dv00 stx   c_temp_1
0883 A53F
0884 A53F AC B2 A9              ldy   head_vp+2
0885 A542 8C BE A9              sty   next_vp+2
0886 A545 AE B0 A9              ldx   head_vp
0887 A548 8E BC A9              stx   next_vp                  ;start this mess from the head
0888 A54B 80 47                 bra   cash_dv03                ;check for 0 first
0889 A54D
0890 A54D 8E B8 A9     cash_dv01 stx   current_vp
0891 A550 AC BE A9              ldy   next_vp+2
0892 A553 8C BA A9              sty   current_vp+2
0893 A556
0894 A556 20 95 A2              jsr   curr_vp_to_ptr           ;convert the current VP to a real pointer
0895 A559
0896 A559 AD D6 A9              lda   c_temp_2                 ;delete all non-deferred blocks?
0897 A55C F0 0A                 beq   do_all_please
0898 A55E
0899 A55E AC D4 A9              ldy   c_temp_1
0900 A561 B7 5A                 lda   [<cache_cur_ptr],y
0901 A563 CD D6 A9              cmp   c_temp_2                 ;equal ?
0902 A566 D0 38                 bne   cash_dv04                ;nope
0903 A568
0904 A568              ; only pick out the non-deferred blocks
0905 A568
0906 A568              ;                ldx     c_temp_1
0907 A568              ;                cpx     #c_fstnum       ;are we deleting by fst number ?
0908 A568              ;                beq     cash_dv01a      ;yes, don't worry about deferred stuff
0909 A568
0910 A568              ;===========================================================================
0911 A568              ;
0912 A568              ; We no longer skip deferred blocks.  They get kicked out along with
0913 A568              ; other blocks on the device. By Rob Turner 1/25/88
0914 A568              ;
0915 A568              ;===========================================================================
0916 A568              do_all_please                           ;
0917 A568 A0 1C 00              ldy   #c_priority
0918 A56B B7 5A                 lda   [<cache_cur_ptr],y
0919 A56D 10 10                 bpl   cash_dv01a               ;Block is not deferred
0920 A56F
0921 A56F AD D6 A9              lda   c_temp_2                 ;removing all non-deferred blocks?
0922 A572 F0 2C                 beq   cash_dv04                ;yes, so skip this block
0923 A574
0924 A574 2C E0 A9              bit   message_shown            ;have we told the user about damage?
0925 A577 30 06                 bmi   cash_dv01a               ;Yes!
0926 A579
0927 A579 20 B6 A5              jsr   show_message             ;tell the user
0928 A57C CE E0 A9              dec   message_shown
0929 A57F
0930 A57F              ;
0931 A57F              ; we've located a block for deletion
0932 A57F              ;
0933 A57F 22 27 A4 00  cash_dv01a jsl   cache_xdelete          ;delete this guy
0934 A583 90 03                 bcc   cash_dv02                ;skip if no error
0935 A585 4C 11 A9              jmp   cache_error              ;i don't know why
0936 A588
0937 A588 AD D8 A9     cash_dv02 lda   c_temp_nvp              ;restore next_vp
0938 A58B 8D BC A9              sta   next_vp
0939 A58E AD DA A9              lda   c_temp_nvp+2
0940 A591 8D BE A9              sta   next_vp+2
0941 A594
0942 A594 AE BC A9     cash_dv03 ldx   next_vp
0943 A597 D0 B4                 bne   cash_dv01                ;skip if <> 0
0944 A599 AC BE A9              ldy   next_vp+2
0945 A59C D0 AF                 bne   cash_dv01                ;skip if <> 0
0946 A59E 80 13                 bra   cash_dv05                ;it's 0, we done deleting
0947 A5A0
0948 A5A0              ; it's not this cell, follow forward link and try again.
0949 A5A0
0950 A5A0 A0 00 00     cash_dv04 ldy   #c_lru_fwd
0951 A5A3 B7 5A                 lda   [<cache_cur_ptr],y
0952 A5A5 AA                    tax                            ;low link in x
0953 A5A6 C8                    iny   
0954 A5A7 C8                    iny   
0955 A5A8 B7 5A                 lda   [<cache_cur_ptr],y
0956 A5AA 8D BE A9              sta   next_vp+2
0957 A5AD A8                    tay                            ;hi link in y
0958 A5AE D0 9D                 bne   cash_dv01                ;y <> 0, loop
0959 A5B0 8A                    txa   
0960 A5B1 D0 9A                 bne   cash_dv01                ;x <> 0, loop
0961 A5B3
0962 A5B3              ; the forward link is 0, we're all done here.
0963 A5B3
0964 A5B3 AB           cash_dv05 plb                           ;restore caller's data bank
0965 A5B4 18                    clc                            ;indicate no error
0966 A5B5 6B                    rtl   
0967 A5B6                       ENDP 
0968 A5B6
0969 A5B6              ;-----------------------------------------------------------------------------
0970 A5B6              ;Show_Message:  This routine will tell the user that the volume is
0971 A5B6              ;               possible damaged.
0972 A5B6              ;-----------------------------------------------------------------------------
0973 A5B6
0974 A5B6                       EXPORT show_message
0975 A5B6              show_message PROC 
0976 A5B6                                                      ;using   common_equ
0977 A5B6                                                      ;using   cache_data
0978 A5B6
0979 A5B6 A5 5C                 lda   <cache_cur_ptr+2
0980 A5B8 48                    pha                            ;save the zeropage pointer
0981 A5B9 A5 5A                 lda   <cache_cur_ptr
0982 A5BB 48                    pha   
0983 A5BC
0984 A5BC A0 18 00              ldy   #c_volumeid              ;get the volume id please
0985 A5BF B7 5A                 lda   [<cache_cur_ptr],y
0986 A5C1 F0 34                 beq   end_show                 ;major problem
0987 A5C3
0988 A5C3 22 48 FC 01           jsl   find_vcr                 ;go and get the vcr ptr
0989 A5C7 B0 2E                 bcs   end_show                 ;major problem
0990 A5C9
0991 A5C9 20 9B A2              jsr   XY_to_cur_ptr            ;deref X and Y & setup cache_cur_ptr with real address.
0992 A5CC
0993 A5CC A0 02 00              ldy   #vcr_name                ;index to volume name
0994 A5CF B7 5A                 lda   [<cache_cur_ptr],y
0995 A5D1 AA                    tax   
0996 A5D2 C8                    iny   
0997 A5D3 C8                    iny   
0998 A5D4 B7 5A                 lda   [<cache_cur_ptr],y
0999 A5D6 A8                    tay   
1000 A5D7 20 9B A2              jsr   XY_to_cur_ptr            ;deref X and Y & setup cache_cur_ptr with real address.
1001 A5DA
1002 A5DA A7 5A                 lda   [<cache_cur_ptr]
1003 A5DC EB                    xba                            ;convert length word to length byte
1004 A5DD 87 5A                 sta   [<cache_cur_ptr]
1005 A5DF
1006 A5DF F4 10 00              pea   $0010                    ;error message number
1007 A5E2 A6 5C                 ldx   <cache_cur_ptr+2
1008 A5E4 A5 5A                 lda   <cache_cur_ptr           ;low word of address
1009 A5E6 1A                    inc   a                        ;point to length byte
1010 A5E7 D0 01                 bne   high_ok
1011 A5E9 E8                    inx                            ;advance the bank address
1012 A5EA              high_ok                                 ;
1013 A5EA DA                    phx                            ;high word
1014 A5EB 48                    pha                            ;low word
1015 A5EC
1016 A5EC 48                    pha                            ;garbage
1017 A5ED 48                    pha   
1018 A5EE 22 94 FC 01           jsl   report_error
1019 A5F2
1020 A5F2 A7 5A                 lda   [<cache_cur_ptr]
1021 A5F4 EB                    xba                            ;convert length byte to length word
1022 A5F5 87 5A                 sta   [<cache_cur_ptr]
1023 A5F7
1024 A5F7              end_show                                ;
1025 A5F7 68                    pla   
1026 A5F8 85 5A                 sta   <cache_cur_ptr
1027 A5FA 68                    pla   
1028 A5FB 85 5C                 sta   <cache_cur_ptr+2
1029 A5FD 60                    rts   
1030 A5FE                       ENDP 
1031 A5FE              ;-----------------------------------------------------------------------------
1032 A5FE              ; CASH_FLSH_DEF -- write to disk the deferred cache block(s)
1033 A5FE              ;
1034 A5FE              ; This routine will try to write to disk the deferred cache blocks belonging
1035 A5FE              ; to a specific volume id.  After being written to disk, these deferred cache
1036 A5FE              ; blocks will be downgraded to regular cache blocks.
1037 A5FE              ;
1038 A5FE              ; Input and output is passed to this routine by GS/OS direct page and full
1039 A5FE              ; native mode is always assumed.
1040 A5FE              ;
1041 A5FE              ; inputs: A = don't care                outputs: A = trashed
1042 A5FE              ;         X = don't care                         X = trashed
1043 A5FE              ;         Y = don't care                         Y = trashed
1044 A5FE              ;         D = gs/os direct page                  D = i didn't change it
1045 A5FE              ;         B = don't care                         B = preserved
1046 A5FE              ;         K = don't care                         K = preserved
1047 A5FE              ;    LCbank = don't care                    LCbank = i didn't change it 
1048 A5FE              ;
1049 A5FE              ; on output: c = 0 means no error, the volume ids deferred blocks have been
1050 A5FE              ;                  written to disk
1051 A5FE              ;            c = 1 means something screwed up, couldn't write to disk all
1052 A5FE              ;                  deferred blocks of the given volume id
1053 A5FE              ;
1054 A5FE              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1055 A5FE              ; author: Ray (Rowdy Yates) Chiang
1056 A5FE              ;-----------------------------------------------------------------------------
1057 A5FE
1058 A5FE                       EXPORT cash_flsh_def
1059 A5FE              cash_flsh_def PROC 
1060 A5FE                                                      ;using   common_equ
1061 A5FE                                                      ;using   cache_data
1062 A5FE
1063 A5FE 8B                    phb                            ;save caller's data bank
1064 A5FF 4B                    phk   
1065 A600 AB                    plb                            ;set data bank to ourspace
1066 A601
1067 A601 20 80 A2              jsr   deref_bucket             ;Deref the bucket table and setup cache_bkt_ptr
1068 A604
1069 A604 A6 1A                 ldx   <drvr_cache              ;get this
1070 A606 DA                    phx                            ;save this for later
1071 A607 64 1A                 stz   <drvr_cache
1072 A609
1073 A609              ;-----------------------------------------------------------------------------
1074 A609              ;
1075 A609              ;-----------------------------------------------------------------------------
1076 A609
1077 A609 AE B0 A9              ldx   head_vp                  ;start this mess from the head
1078 A60C AC B2 A9              ldy   head_vp+2
1079 A60F
1080 A60F              cfd_00    
1081 A60F 20 95 A2              jsr   curr_vp_to_ptr           ;convert the current VP to a real pointer
1082 A612
1083 A612              ;-----------------------------------------------------------------------------
1084 A612              ; we can only write out cell(s) that are deferred.  we may have to walk the
1085 A612              ; entire list to find it but we know it's there.
1086 A612              ;-----------------------------------------------------------------------------
1087 A612
1088 A612 A0 1C 00              ldy   #c_priority
1089 A615 B7 5A                 lda   [<cache_cur_ptr],y       ;get this cell's priority
1090 A617 30 13                 bmi   cfd_02                   ;skip if deferred
1091 A619
1092 A619 A0 00 00     cfd_00a  ldy   #c_lru_fwd
1093 A61C B7 5A                 lda   [<cache_cur_ptr],y
1094 A61E C8                    iny   
1095 A61F C8                    iny   
1096 A620 AA                    tax                            ;save backward vp link, lo
1097 A621 D0 04                 bne   cfd_01                   ;skip if not 0
1098 A623
1099 A623 B7 5A                 lda   [<cache_cur_ptr],y
1100 A625 F0 22                 beq   cash_fd09                ;we found a vp of $0000
1101 A627
1102 A627 B7 5A        cfd_01   lda   [<cache_cur_ptr],y
1103 A629 A8                    tay                            ;save backward vp link, hi
1104 A62A 80 E3                 bra   cfd_00                   ;loop for next cell
1105 A62C
1106 A62C              ; if we get here then we found a deferred block, check for volume id
1107 A62C
1108 A62C A0 18 00     cfd_02   ldy   #c_volumeid
1109 A62F B7 5A                 lda   [<cache_cur_ptr],y       ;get volume id
1110 A631 C5 18                 cmp   <drvr_vol_id             ;same ?
1111 A633 D0 E4                 bne   cfd_00a                  ;no, check next cell
1112 A635
1113 A635              ; if we get here then we found a match, write this puppy out
1114 A635
1115 A635 EE DE A9              inc   no_find                  ;disable find routine
1116 A638 20 E0 A8              jsr   write_to_disk            ;write this block to disk
1117 A63B B0 0C                 bcs   cash_fd09                ;this wasn't expected
1118 A63D
1119 A63D              ; if we get here then the writes okay and now turn off deferred status
1120 A63D
1121 A63D A0 1C 00              ldy   #c_priority
1122 A640 B7 5A                 lda   [<cache_cur_ptr],y
1123 A642 29 FF 7F              and   #$7fff                   ;turn off bit 15
1124 A645 97 5A                 sta   [<cache_cur_ptr],y
1125 A647 80 D0                 bra   cfd_00a                  ;loop to find next one if any
1126 A649
1127 A649 9C DE A9     cash_fd09 stz   no_find                 ;re-enable find routine
1128 A64C FA                    plx                            ;restore drvr_cache
1129 A64D 86 1A                 stx   <drvr_cache
1130 A64F AB                    plb                            ;restore caller's data bank
1131 A650 18                    clc                            ;indicate no error
1132 A651 6B                    rtl   
1133 A652
1134 A652                       ENDP 
1135 A652              ;-----------------------------------------------------------------------------
1136 A652              ; CASH_SHUTDOWN -- shutdown the cache
1137 A652              ;
1138 A652              ; This routine will try to shutdown the cache by deleting each entry one at a
1139 A652              ; time.  The LRU list will be used for deletion, the bucket lists will not be
1140 A652              ; used nor updated.  The state of the cache is unknown if there's an error.
1141 A652              ;
1142 A652              ; Input and output is passed to this routine by GS/OS direct page and full
1143 A652              ; native mode is always assumed.
1144 A652              ;
1145 A652              ; inputs: A = don't care                outputs: A = trashed
1146 A652              ;         X = don't care                         X = trashed
1147 A652              ;         Y = don't care                         Y = trashed
1148 A652              ;         D = gs/os direct page                  D = i didn't change it
1149 A652              ;         B = don't care                         B = preserved
1150 A652              ;         K = don't care                         K = preserved
1151 A652              ;    LCbank = don't care                    LCbank = i didn't change it 
1152 A652              ;
1153 A652              ; on output: c = 0 means no error, the cache has been shutdown
1154 A652              ;            c = 1 means something screwed up, the cache is unreliable now
1155 A652              ;
1156 A652              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1157 A652              ; author: Ray (Rowdy Yates) Chiang
1158 A652              ;-----------------------------------------------------------------------------
1159 A652
1160 A652                       EXPORT cash_shutdown
1161 A652              cash_shutdown PROC 
1162 A652                                                      ;using   common_equ
1163 A652                                                      ;using   cache_data
1164 A652
1165 A652 8B                    phb                            ;save caller's data bank
1166 A653 4B                    phk   
1167 A654 AB                    plb                            ;set data bank to ourspace
1168 A655 20 80 A2              jsr   deref_bucket             ;Deref the bucket table and setup cache_bkt_ptr
1169 A658
1170 A658 80 08                 bra   cash_sd01
1171 A65A
1172 A65A 20 66 A8     cash_sd00 jsr   d_from_tail             ;delete one from the tail
1173 A65D 90 03                 bcc   cash_sd01                ;skip if no problem
1174 A65F 4C 11 A9              jmp   cache_error              ;not suppose to happen
1175 A662
1176 A662 AE B4 A9     cash_sd01 ldx   tail_vp
1177 A665 D0 F3                 bne   cash_sd00                ;head <> 0, at least 1 cell left
1178 A667 AC B6 A9              ldy   tail_vp+2
1179 A66A D0 EE                 bne   cash_sd00                ;head <> 0, at least 1 cell left
1180 A66C
1181 A66C              ; lastly, get rid of the bucket array
1182 A66C
1183 A66C AE C4 A9              ldx   bucket_vp
1184 A66F AC C6 A9              ldy   bucket_vp+2
1185 A672 22 20 FC 01           jsl   release_seg
1186 A676 90 03                 bcc   cash_sd02                ;skip if no problem
1187 A678 4C 11 A9              jmp   cache_error              ;mike's got a problem
1188 A67B
1189 A67B              cash_sd02  
1190 A67B                       Import Cache_out_of_Queue
1191 A67B 20 2F A9              jsr   Cache_out_of_Queue
1192 A67E AB                    plb                            ;restore caller's data bank
1193 A67F 18                    clc                            ;indicate no error
1194 A680 6B                    rtl   
1195 A681
1196 A681                       ENDP 
1197 A681              ;-----------------------------------------------------------------------------
1198 A681
1199 A681                       EXPORT cache_misc
1200 A681              cache_misc PROC 
1201 A681                                                      ;using   common_equ
1202 A681                                                      ;using   cache_data
1203 A681
1204 A681              ;-----------------------------------------------------------------------------
1205 A681              ; ENUF_ROOM -- checks for space remaining in cache
1206 A681              ;
1207 A681              ; This routine will check the cache free space to see if there's enough room
1208 A681              ; for adding another cell into the chain.  If there's not enough room then
1209 A681              ; LRU will be invoked and cells will be deleted until there's enough room for
1210 A681              ; the requested block.
1211 A681              ;
1212 A681              ; inputs: A = cell size                 outputs: A = trashed
1213 A681              ;         X = don't care                         X = trashed
1214 A681              ;         Y = don't care                         Y = trashed
1215 A681              ;         D = gs/os direct page                  D = i didn't change it
1216 A681              ;         B = don't care                         B = preserved
1217 A681              ;         K = don't care                         K = preserved
1218 A681              ;    LCbank = don't care                    LCbank = i didn't change it 
1219 A681              ;
1220 A681              ; on output: c = 0 means no error, there's enough room for the request size
1221 A681              ;            c = 1 means something screwed up, it's probably mike's fault
1222 A681              ;
1223 A681              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1224 A681              ; author: Ray (Rowdy Yates) Chiang
1225 A681              ;-----------------------------------------------------------------------------
1226 A681
1227 A681                       EXPORT enuf_room
1228 A681              enuf_room                               ;
1229 A681                       import in_queue
1230 A681
1231 A681 20 90 A8              jsr   is_there_room            ;is there room for something ?
1232 A684 B0 2B                 bcs   enuf_02                  ;there's enough room
1233 A686
1234 A686 AD B4 A9              lda   tail_vp
1235 A689 D0 1F                 bne   enuf_00                  ;skip if not 0
1236 A68B AD B6 A9              lda   tail_vp+2
1237 A68E D0 1A                 bne   enuf_00                  ;skip if not 0
1238 A690
1239 A690              ; there isn't enough room yet, the tail_vp is 0, something is all screwed up.
1240 A690              ; Or sessions are enabled and the cache is full.  If this is the case
1241 A690              ; then I will do an end session and flush the word.
1242 A690              ;
1243 A690
1244 A690 AD E2 A9     put_in_queue lda   in_queue             ;lets see if we have queued up to check for sessions
1245 A693 30 13                 bmi   @already_in
1246 A695
1247 A695 A9 FF FF              lda   #$FFFF
1248 A698 8D E2 A9              sta   in_queue                 ;do not add to the queue until I have ran once
1249 A69B
1250 A69B A9 01 00              lda   #$0001                   ;priority 1
1251 A69E A2 A4 A2              ldx   #auto_flush_handler
1252 A6A1 A0 00 00              ldy   #^auto_flush_handler
1253 A6A4 22 88 FC 01           jsl   signal                   ;add in our signal handler
1254 A6A8              @already_in  
1255 A6A8 38                    sec                            ;this should never happen
1256 A6A9 60                    rts   
1257 A6AA
1258 A6AA              ; there ain't enough room to cache the requested cell.  enforce LRU until
1259 A6AA              ; there's enough room or error whichever is first.
1260 A6AA
1261 A6AA 20 66 A8     enuf_00  jsr   d_from_tail              ;delete one from the tail
1262 A6AD 90 D2                 bcc   enuf_room                ;skip if no problem
1263 A6AF B0 DF                 bcs   put_in_queue             ;let error migrate up
1264 A6B1
1265 A6B1 18           enuf_02  clc   
1266 A6B2 60                    rts   
1267 A6B3
1268 A6B3              ;-----------------------------------------------------------------------------
1269 A6B3              ; ADDME2LRU -- adds a block to the LRU chain
1270 A6B3              ;
1271 A6B3              ; This routine will take the cache cell pointed to by x and y and add it to
1272 A6B3              ; the start of the LRU chain.
1273 A6B3              ;
1274 A6B3              ; inputs: A = don't care                outputs: A = trashed
1275 A6B3              ;         X = vp to cache cell, lo               X = trashed
1276 A6B3              ;         Y = vp to cache cell, hi               Y = trashed
1277 A6B3              ;         D = gs/os direct page                  D = i didn't change it
1278 A6B3              ;         B = don't care                         B = preserved
1279 A6B3              ;         K = don't care                         K = preserved
1280 A6B3              ;    LCbank = don't care                    LCbank = i didn't change it 
1281 A6B3              ;
1282 A6B3              ; on output: c = don't care
1283 A6B3              ;
1284 A6B3              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1285 A6B3              ; author: Ray (Rowdy Yates) Chiang
1286 A6B3              ;-----------------------------------------------------------------------------
1287 A6B3
1288 A6B3                       EXPORT addme2lru
1289 A6B3              addme2lru                               ;
1290 A6B3 AD B0 A9              lda   head_vp
1291 A6B6 8D BC A9              sta   next_vp
1292 A6B9 AD B2 A9              lda   head_vp+2
1293 A6BC 8D BE A9              sta   next_vp+2
1294 A6BF 8E B0 A9              stx   head_vp
1295 A6C2 8C B2 A9              sty   head_vp+2                ;this is the new LRU head
1296 A6C5 20 9B A2              jsr   XY_to_cur_ptr            ;deref X and Y & setup cache_cur_ptr with real address.
1297 A6C8
1298 A6C8 A0 00 00              ldy   #c_lru_fwd               ;offset to forward vp link
1299 A6CB AD BC A9              lda   next_vp
1300 A6CE 97 5A                 sta   [<cache_cur_ptr],y
1301 A6D0 C8                    iny   
1302 A6D1 C8                    iny   
1303 A6D2 AD BE A9              lda   next_vp+2
1304 A6D5 97 5A                 sta   [<cache_cur_ptr],y
1305 A6D7
1306 A6D7 A0 04 00              ldy   #c_lru_bwd               ;offset to backward vp link
1307 A6DA A9 00 00              lda   #$0000
1308 A6DD 97 5A                 sta   [<cache_cur_ptr],y
1309 A6DF C8                    iny   
1310 A6E0 C8                    iny   
1311 A6E1 97 5A                 sta   [<cache_cur_ptr],y
1312 A6E3
1313 A6E3 AD BC A9              lda   next_vp
1314 A6E6 D0 12                 bne   addme00
1315 A6E8 AD BE A9              lda   next_vp+2
1316 A6EB D0 0D                 bne   addme00
1317 A6ED AD B0 A9              lda   head_vp
1318 A6F0 8D B4 A9              sta   tail_vp
1319 A6F3 AD B2 A9              lda   head_vp+2
1320 A6F6 8D B6 A9              sta   tail_vp+2
1321 A6F9 60                    rts   
1322 A6FA
1323 A6FA AE BC A9     addme00  ldx   next_vp
1324 A6FD AC BE A9              ldy   next_vp+2
1325 A700 22 38 FC 01           jsl   deref
1326 A704 86 5E                 stx   <cache_nxt_ptr
1327 A706 84 60                 sty   <cache_nxt_ptr+2
1328 A708
1329 A708 A0 04 00              ldy   #c_lru_bwd               ;offset to backward vp link
1330 A70B AD B0 A9              lda   head_vp
1331 A70E 97 5E                 sta   [<cache_nxt_ptr],y
1332 A710 C8                    iny   
1333 A711 C8                    iny   
1334 A712 AD B2 A9              lda   head_vp+2
1335 A715 97 5E                 sta   [<cache_nxt_ptr],y
1336 A717 60                    rts   
1337 A718
1338 A718              ;-----------------------------------------------------------------------------
1339 A718              ; add2bktlist -- adds a block to the bucket chain
1340 A718              ;
1341 A718              ; This routine will take the cache cell pointed to by head_vp and add it to
1342 A718              ; the head of the bucket chain.
1343 A718              ;
1344 A718              ; inputs: A = bucket number             outputs: A = trashed
1345 A718              ;         X = don't care                         X = trashed
1346 A718              ;         Y = don't care                         Y = trashed
1347 A718              ;         D = gs/os direct page                  D = i didn't change it
1348 A718              ;         B = don't care                         B = preserved
1349 A718              ;         K = don't care                         K = preserved
1350 A718              ;    LCbank = don't care                    LCbank = i didn't change it 
1351 A718              ;
1352 A718              ; on output: c = 0 means no error, the cache cell has been added to the head
1353 A718              ;                  of the bucket chain
1354 A718              ;            c = 1 means something screwed up, the operation was not completed
1355 A718              ;
1356 A718              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1357 A718              ; author: Ray (Rowdy Yates) Chiang
1358 A718              ;-----------------------------------------------------------------------------
1359 A718
1360 A718                       EXPORT add2bktlist
1361 A718              add2bktlist                             ;
1362 A718 20 C0 A8              jsr   look_in_array            ;look in bucket array for it
1363 A71B 90 08                 bcc   add2d00                  ;skip if there's something there
1364 A71D
1365 A71D 9C BC A9              stz   next_vp                  ;set forward link to nil
1366 A720 9C BE A9              stz   next_vp+2
1367 A723 80 1D                 bra   add2d01
1368 A725
1369 A725 8E BC A9     add2d00  stx   next_vp
1370 A728 8C BE A9              sty   next_vp+2
1371 A72B 22 38 FC 01           jsl   deref
1372 A72F 86 5E                 stx   <cache_nxt_ptr
1373 A731 84 60                 sty   <cache_nxt_ptr+2
1374 A733
1375 A733 A0 0C 00              ldy   #c_bkt_bwd               ;offset to backward vp link
1376 A736 AD B0 A9              lda   head_vp
1377 A739 97 5E                 sta   [<cache_nxt_ptr],y
1378 A73B C8                    iny   
1379 A73C C8                    iny   
1380 A73D AD B2 A9              lda   head_vp+2
1381 A740 97 5E                 sta   [<cache_nxt_ptr],y
1382 A742
1383 A742 AD CE A9     add2d01  lda   c_temp_element
1384 A745 0A                    asl   a
1385 A746 0A                    asl   a                        ;multiply by 4 to make into index
1386 A747 A8                    tay   
1387 A748 AD B0 A9              lda   head_vp
1388 A74B 97 66                 sta   [<cache_bkt_ptr],y
1389 A74D C8                    iny   
1390 A74E C8                    iny   
1391 A74F AD B2 A9              lda   head_vp+2
1392 A752 97 66                 sta   [<cache_bkt_ptr],y
1393 A754
1394 A754 A0 08 00              ldy   #c_bkt_fwd               ;offset to forward vp link
1395 A757 AD BC A9              lda   next_vp
1396 A75A 97 5A                 sta   [<cache_cur_ptr],y
1397 A75C C8                    iny   
1398 A75D C8                    iny   
1399 A75E AD BE A9              lda   next_vp+2
1400 A761 97 5A                 sta   [<cache_cur_ptr],y
1401 A763
1402 A763 A0 0C 00              ldy   #c_bkt_bwd               ;offset to backward vp link
1403 A766 A9 00 00              lda   #$0000
1404 A769 97 5A                 sta   [<cache_cur_ptr],y
1405 A76B C8                    iny   
1406 A76C C8                    iny   
1407 A76D 97 5A                 sta   [<cache_cur_ptr],y
1408 A76F
1409 A76F 18                    clc   
1410 A770 60                    rts   
1411 A771
1412 A771              ;-----------------------------------------------------------------------------
1413 A771              ; CACHE_SEARCH -- searches the cache for the requested block
1414 A771              ;
1415 A771              ; This routine will search the bucket list to locate the requested block. If
1416 A771              ; it's found, cache_cur_ptr will be pointing to that block.
1417 A771              ;
1418 A771              ; inputs: A = don't care                outputs: A = trashed
1419 A771              ;         X = don't care                         X = trashed
1420 A771              ;         Y = don't care                         Y = trashed
1421 A771              ;         D = gs/os direct page                  D = i didn't change it
1422 A771              ;         B = don't care                         B = preserved
1423 A771              ;         K = don't care                         K = preserved
1424 A771              ;    LCbank = don't care                    LCbank = i didn't change it 
1425 A771              ;
1426 A771              ; on output: c = 0 means no error, the requested block has been found
1427 A771              ;            c = 1 means something screwed up or the block's not in the cache
1428 A771              ;
1429 A771              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1430 A771              ; author: Ray (Rowdy Yates) Chiang
1431 A771              ;-----------------------------------------------------------------------------
1432 A771
1433 A771                       EXPORT cache_search
1434 A771              cache_search                            ;
1435 A771 20 C0 A8              jsr   look_in_array            ;look in bucket array for it
1436 A774 90 01                 bcc   cash_s00                 ;skip if maybe
1437 A776 60                    rts                            ;error, it ain't there
1438 A777
1439 A777              ; the block should be somewhere in this bucket list, look for it
1440 A777
1441 A777              cash_s00  
1442 A777 20 95 A2              jsr   curr_vp_to_ptr           ;convert the current VP to a real pointer
1443 A77A
1444 A77A A0 10 00              ldy   #c_blknum                ;point to block number, lo
1445 A77D B7 5A                 lda   [<cache_cur_ptr],y
1446 A77F C5 10                 cmp   <drvr_blk_num            ;equal ?
1447 A781 D0 1C                 bne   cash_s01                 ;nope
1448 A783 C8                    iny   
1449 A784 C8                    iny                            ;point to block number, hi
1450 A785 B7 5A                 lda   [<cache_cur_ptr],y
1451 A787 C5 12                 cmp   <drvr_blk_num+2          ;equal ?
1452 A789 D0 14                 bne   cash_s01                 ;nope
1453 A78B
1454 A78B A0 14 00              ldy   #c_blksize               ;point to block size
1455 A78E B7 5A                 lda   [<cache_cur_ptr],y
1456 A790 C5 14                 cmp   <drvr_blk_size           ;equal ?
1457 A792 D0 1D                 bne   cash_s02                 ;nope  ----------> L O O K  !!!
1458 A794
1459 A794 A0 1A 00              ldy   #c_devnum                ;point to device number
1460 A797 B7 5A                 lda   [<cache_cur_ptr],y
1461 A799 C5 00                 cmp   <drvr_dev_num            ;equal ?
1462 A79B D0 02                 bne   cash_s01                 ;nope
1463 A79D 18                    clc                            ;we've located the requested cell
1464 A79E 60                    rts   
1465 A79F
1466 A79F              ; it's not this cell, follow forward link and try again.
1467 A79F
1468 A79F A0 08 00     cash_s01 ldy   #c_bkt_fwd
1469 A7A2 B7 5A                 lda   [<cache_cur_ptr],y
1470 A7A4 AA                    tax                            ;low link in x
1471 A7A5 C8                    iny   
1472 A7A6 C8                    iny   
1473 A7A7 B7 5A                 lda   [<cache_cur_ptr],y
1474 A7A9 A8                    tay                            ;high link in y
1475 A7AA D0 CB                 bne   cash_s00                 ;y <> 0, loop
1476 A7AC 8A                    txa   
1477 A7AD D0 C8                 bne   cash_s00                 ;x <> 0, loop
1478 A7AF
1479 A7AF              ; the forward link is 0, seems like we didn't find it
1480 A7AF
1481 A7AF 38                    sec   
1482 A7B0 60                    rts   
1483 A7B1
1484 A7B1              ;-----------------------------------------------------------------------------
1485 A7B1              ; if we get here then we found a block in the cache that's a different size
1486 A7B1              ; than the requested size.  this could be caused by different FSTs asking for
1487 A7B1              ; it.  in any case, to be safe and not sorry, this found block will be deleted
1488 A7B1              ; from the cache and the find_block routine will return with carry set.  the
1489 A7B1              ; requestor will have to get that block off the disk.
1490 A7B1              ;-----------------------------------------------------------------------------
1491 A7B1
1492 A7B1 22 27 A4 00  cash_s02 jsl   cache_xdelete            ;current_vp still valid here
1493 A7B5 38                    sec                            ;pretend we didn't find the block
1494 A7B6 60                    rts   
1495 A7B7
1496 A7B7              ;-----------------------------------------------------------------------------
1497 A7B7              ; SEARCH_VOL_ID -- searches the cache for a volume ids deferred block
1498 A7B7              ;
1499 A7B7              ; This routine will search the cache list for a volume ids deferred block.
1500 A7B7              ; If we find any, then we'll return carry clear otherwise carry set.
1501 A7B7              ;
1502 A7B7              ; inputs: A = volume id                 outputs: A = trashed
1503 A7B7              ;         X = don't care                         X = trashed
1504 A7B7              ;         Y = don't care                         Y = trashed
1505 A7B7              ;         D = gs/os direct page                  D = i didn't change it
1506 A7B7              ;         B = don't care                         B = preserved
1507 A7B7              ;         K = don't care                         K = preserved
1508 A7B7              ;    LCbank = don't care                    LCbank = i didn't change it 
1509 A7B7              ;
1510 A7B7              ; on output: c = 0 means no error, the requested volume id has deferred blocks
1511 A7B7              ;            c = 1 means something screwed up or no deferred blocks found
1512 A7B7              ;
1513 A7B7              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1514 A7B7              ; author: Ray (Rowdy Yates) Chiang
1515 A7B7              ;-----------------------------------------------------------------------------
1516 A7B7
1517 A7B7                       EXPORT search_vol_id
1518 A7B7              search_vol_id                           ;
1519 A7B7 AD B4 A9              lda   tail_vp
1520 A7BA 0D B6 A9              ora   tail_vp+2
1521 A7BD D0 02                 bne   svi_0010
1522 A7BF 38                    sec                            ;no blocks
1523 A7C0 60                    rts   
1524 A7C1
1525 A7C1              svi_0010                                ;
1526 A7C1 AE B4 A9              ldx   tail_vp
1527 A7C4 AC B6 A9              ldy   tail_vp+2
1528 A7C7
1529 A7C7              svi_00    
1530 A7C7 20 95 A2              jsr   curr_vp_to_ptr           ;convert the current VP to a real pointer
1531 A7CA
1532 A7CA A0 1C 00              ldy   #c_priority
1533 A7CD B7 5A                 lda   [<cache_cur_ptr],y       ;get this cell's priority
1534 A7CF 10 0B                 bpl   svi_01                   ;skip if not deferred
1535 A7D1 A0 18 00              ldy   #c_volumeid
1536 A7D4 B7 5A                 lda   [<cache_cur_ptr],y
1537 A7D6 C5 18                 cmp   <drvr_vol_id
1538 A7D8 D0 02                 bne   svi_01                   ;skip if not this volume id
1539 A7DA 18                    clc                            ;we found at least one.
1540 A7DB 60                    rts   
1541 A7DC
1542 A7DC A0 04 00     svi_01   ldy   #c_lru_bwd
1543 A7DF B7 5A                 lda   [<cache_cur_ptr],y
1544 A7E1 C8                    iny   
1545 A7E2 C8                    iny   
1546 A7E3 AA                    tax                            ;save backward vp link, lo
1547 A7E4 D0 06                 bne   svi_03                   ;skip if not 0
1548 A7E6 B7 5A                 lda   [<cache_cur_ptr],y
1549 A7E8 D0 04                 bne   svi_03a                  ;skip if not 0
1550 A7EA
1551 A7EA              ;-----------------------------------------------------------------------------
1552 A7EA              ; if we get here then we're at the head of the list and still haven't been
1553 A7EA              ; able to find any blocks that match volume id and deferred bit set.
1554 A7EA              ;-----------------------------------------------------------------------------
1555 A7EA
1556 A7EA 38                    sec                            ;we're at the end
1557 A7EB 60                    rts   
1558 A7EC
1559 A7EC B7 5A        svi_03   lda   [<cache_cur_ptr],y
1560 A7EE A8           svi_03a  tay                            ;save backward vp link, hi
1561 A7EF 80 D6                 bra   svi_00                   ;loop for next cell
1562 A7F1
1563 A7F1              ;-----------------------------------------------------------------------------
1564 A7F1              ; GETLINKS -- fetches the forward and backward vp links
1565 A7F1              ;
1566 A7F1              ; This routine will fetch the forward and backward vp links of either the LRU
1567 A7F1              ; or bucket chain and return them into next_vp and prev_vp.  Additionally, x
1568 A7F1              ; and y will contain prev_vp and prev_vp+2.
1569 A7F1              ;
1570 A7F1              ; inputs: A = don't care                outputs: A = trashed
1571 A7F1              ;         X = offset to backward link            X = prev_vp
1572 A7F1              ;         Y = offset to  forward link            Y = prev_vp+2
1573 A7F1              ;         D = gs/os direct page                  D = i didn't change it
1574 A7F1              ;         B = don't care                         B = preserved
1575 A7F1              ;         K = don't care                         K = preserved
1576 A7F1              ;    LCbank = don't care                    LCbank = i didn't change it 
1577 A7F1              ;
1578 A7F1              ; on output: c = don't care
1579 A7F1              ;
1580 A7F1              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1581 A7F1              ; author: Ray (Rowdy Yates) Chiang
1582 A7F1              ;-----------------------------------------------------------------------------
1583 A7F1
1584 A7F1                       EXPORT getlinks
1585 A7F1              getlinks                                ;
1586 A7F1 B7 5A                 lda   [<cache_cur_ptr],y
1587 A7F3 8D BC A9              sta   next_vp
1588 A7F6 C8                    iny   
1589 A7F7 C8                    iny   
1590 A7F8 B7 5A                 lda   [<cache_cur_ptr],y
1591 A7FA 8D BE A9              sta   next_vp+2
1592 A7FD
1593 A7FD 9B                    txy                            ;offset to backward vp link
1594 A7FE B7 5A                 lda   [<cache_cur_ptr],y
1595 A800 8D C0 A9              sta   prev_vp
1596 A803 AA                    tax   
1597 A804 C8                    iny   
1598 A805 C8                    iny   
1599 A806 B7 5A                 lda   [<cache_cur_ptr],y
1600 A808 8D C2 A9              sta   prev_vp+2
1601 A80B A8                    tay   
1602 A80C 60                    rts   
1603 A80D
1604 A80D              ;-----------------------------------------------------------------------------
1605 A80D              ; SET_FLINK_2NIL -- sets forward vp link to nil
1606 A80D              ;
1607 A80D              ; This routine will set the forward vp link of the cache cell pointed to by
1608 A80D              ; prev_vp to nil.
1609 A80D              ;
1610 A80D              ; inputs: A = offset to forward link    outputs: A = trashed
1611 A80D              ;         X = prev_vp                            X = trashed
1612 A80D              ;         Y = prev_vp+2                          Y = trashed
1613 A80D              ;         D = gs/os direct page                  D = i didn't change it
1614 A80D              ;         B = don't care                         B = preserved
1615 A80D              ;         K = don't care                         K = preserved
1616 A80D              ;    LCbank = don't care                    LCbank = i didn't change it 
1617 A80D              ;
1618 A80D              ; on output: c = don't care
1619 A80D              ;
1620 A80D
1621 A80D              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1622 A80D              ; author: Ray (Rowdy Yates) Chiang
1623 A80D              ;-----------------------------------------------------------------------------
1624 A80D
1625 A80D                       EXPORT set_flink_2nil
1626 A80D              set_flink_2nil                          ;
1627 A80D 8D D0 A9              sta   c_temp_fwd
1628 A810 22 38 FC 01           jsl   deref
1629 A814 86 62                 stx   <cache_pre_ptr
1630 A816 84 64                 sty   <cache_pre_ptr+2
1631 A818
1632 A818 AC D0 A9              ldy   c_temp_fwd               ;offset to forward vp link
1633 A81B A9 00 00              lda   #$0000
1634 A81E 97 62                 sta   [<cache_pre_ptr],y
1635 A820 C8                    iny   
1636 A821 C8                    iny   
1637 A822 97 62                 sta   [<cache_pre_ptr],y
1638 A824 60                    rts   
1639 A825
1640 A825              ;-----------------------------------------------------------------------------
1641 A825              ; UNLINK -- unlinks the current cache cell
1642 A825              ;
1643 A825              ; This routine will link together the cache cells pointed to by next_vp and
1644 A825              ; prev_vp.  By doing this, the current cache cell will be 'unlink'ed from
1645 A825              ; either the LRU or bucket chains.
1646 A825              ;
1647 A825              ; inputs: A = don't care                outputs: A = trashed
1648 A825              ;         X = offset to backward link            X = trashed
1649 A825              ;         Y = offset to  forward link            Y = trashed
1650 A825              ;         D = gs/os direct page                  D = i didn't change it
1651 A825              ;         B = don't care                         B = preserved
1652 A825              ;         K = don't care                         K = preserved
1653 A825              ;    LCbank = don't care                    LCbank = i didn't change it 
1654 A825              ;
1655 A825              ; on output: c = don't care
1656 A825              ;
1657 A825              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1658 A825              ; author: Ray (Rowdy Yates) Chiang
1659 A825              ;-----------------------------------------------------------------------------
1660 A825
1661 A825                       EXPORT unlink
1662 A825              unlink                                  ;
1663 A825 8E D2 A9              stx   c_temp_bwd
1664 A828 8C D0 A9              sty   c_temp_fwd
1665 A82B
1666 A82B AE C0 A9              ldx   prev_vp
1667 A82E AC C2 A9              ldy   prev_vp+2
1668 A831 22 38 FC 01           jsl   deref
1669 A835 86 62                 stx   <cache_pre_ptr
1670 A837 84 64                 sty   <cache_pre_ptr+2
1671 A839
1672 A839 AC D0 A9              ldy   c_temp_fwd               ;offset to forward vp link
1673 A83C AD BC A9              lda   next_vp
1674 A83F 97 62                 sta   [<cache_pre_ptr],y
1675 A841 C8                    iny   
1676 A842 C8                    iny   
1677 A843 AD BE A9              lda   next_vp+2
1678 A846 97 62                 sta   [<cache_pre_ptr],y
1679 A848
1680 A848                       EXPORT unlink_bwd
1681 A848              unlink_bwd                              ;
1682 A848 AE BC A9              ldx   next_vp
1683 A84B AC BE A9              ldy   next_vp+2
1684 A84E 22 38 FC 01           jsl   deref
1685 A852 86 5E                 stx   <cache_nxt_ptr
1686 A854 84 60                 sty   <cache_nxt_ptr+2
1687 A856
1688 A856 AC D2 A9              ldy   c_temp_bwd               ;offset to backward vp link
1689 A859 AD C0 A9              lda   prev_vp
1690 A85C 97 5E                 sta   [<cache_nxt_ptr],y
1691 A85E C8                    iny   
1692 A85F C8                    iny   
1693 A860 AD C2 A9              lda   prev_vp+2
1694 A863 97 5E                 sta   [<cache_nxt_ptr],y
1695 A865 60                    rts   
1696 A866
1697 A866              ;-----------------------------------------------------------------------------
1698 A866              ; D_FROM_TAIL -- deletes a cache cell from the LRU tail
1699 A866              ;
1700 A866              ; This routine will try to delete the last recently used cache cell that's
1701 A866              ; not deferred from the cache list.
1702 A866              ;
1703 A866              ; inputs: A = don't care                outputs: A = trashed
1704 A866              ;         X = don't care                         X = trashed
1705 A866              ;         Y = don't care                         Y = trashed
1706 A866              ;         D = gs/os direct page                  D = i didn't change it
1707 A866              ;         B = don't care                         B = preserved
1708 A866              ;         K = don't care                         K = preserved
1709 A866              ;    LCbank = don't care                    LCbank = i didn't change it 
1710 A866              ;
1711 A866              ; on output: c = 0 means a cache cell was deleted
1712 A866              ;            c = 1 means it's mike's fault or they're all deferred blocks
1713 A866              ;
1714 A866              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1715 A866              ; author: Ray (Rowdy Yates) Chiang
1716 A866              ;-----------------------------------------------------------------------------
1717 A866
1718 A866                       EXPORT d_from_tail
1719 A866              d_from_tail                             ;
1720 A866 AE B4 A9              ldx   tail_vp
1721 A869 AC B6 A9              ldy   tail_vp+2
1722 A86C
1723 A86C              dft_00    
1724 A86C 20 95 A2              jsr   curr_vp_to_ptr           ;convert the current VP to a real pointer
1725 A86F
1726 A86F              ;-----------------------------------------------------------------------------
1727 A86F              ; we can only delete cell(s) that are not deferred.  we may have to walk the
1728 A86F              ; entire list to find somebody who's not deferred.
1729 A86F              ;-----------------------------------------------------------------------------
1730 A86F
1731 A86F A0 1C 00              ldy   #c_priority
1732 A872 B7 5A                 lda   [<cache_cur_ptr],y       ;get this cell's priority
1733 A874 10 15                 bpl   dft_02                   ;skip if not deferred
1734 A876 A0 04 00              ldy   #c_lru_bwd
1735 A879 B7 5A                 lda   [<cache_cur_ptr],y
1736 A87B C8                    iny   
1737 A87C C8                    iny   
1738 A87D AA                    tax                            ;save backward vp link, lo
1739 A87E D0 06                 bne   dft_01                   ;skip if not 0
1740 A880 B7 5A                 lda   [<cache_cur_ptr],y
1741 A882 D0 04                 bne   dft_01a                  ;skip if not 0
1742 A884
1743 A884              ;-----------------------------------------------------------------------------
1744 A884              ; if we get here then we're at the head of the list and still haven't been
1745 A884              ; able to delete anybody.
1746 A884              ;-----------------------------------------------------------------------------
1747 A884
1748 A884 38                    sec                            ;we're at the end
1749 A885 60                    rts   
1750 A886
1751 A886 B7 5A        dft_01   lda   [<cache_cur_ptr],y
1752 A888 A8           dft_01a  tay                            ;save backward vp link, hi
1753 A889 80 E1                 bra   dft_00                   ;loop for next cell
1754 A88B
1755 A88B              ;-----------------------------------------------------------------------------
1756 A88B              ; if we get here then we found a non deferred block, delete this puppy.  The
1757 A88B              ; tail_vp may be updated by the delete routine, we don't mess with it here.
1758 A88B              ;-----------------------------------------------------------------------------
1759 A88B
1760 A88B              dft_02                                  ; 
1761 A88B
1762 A88B 22 27 A4 00  dft_03   jsl   cache_xdelete            ;delete this block
1763 A88F 60                    rts                            ;result in c
1764 A890
1765 A890              ;-----------------------------------------------------------------------------
1766 A890              ; IS_THERE_ROOM -- checks to if there is enough room for the next cache cell
1767 A890              ;
1768 A890              ; It's just a simple 4 byte compare.
1769 A890              ;
1770 A890              ; inputs: A = don't care                outputs: A = trashed
1771 A890              ;         X = don't care                         X = trashed
1772 A890              ;         Y = don't care                         Y = trashed
1773 A890              ;         D = gs/os direct page                  D = i didn't change it
1774 A890              ;         B = don't care                         B = preserved
1775 A890              ;         K = don't care                         K = preserved
1776 A890              ;    LCbank = don't care                    LCbank = i didn't change it 
1777 A890              ;
1778 A890              ; on output: c = 0 means there's not enough room
1779 A890              ;            c = 1 means there's     enough room
1780 A890              ;
1781 A890              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1782 A890              ; author: Ray (Rowdy Yates) Chiang
1783 A890              ;-----------------------------------------------------------------------------
1784 A890
1785 A890                       EXPORT is_there_room
1786 A890              is_there_room                           ;
1787 A890 38                    sec   
1788 A891 AD C8 A9              lda   c_bytes_free
1789 A894 ED CC A9              sbc   c_request_size
1790 A897 AD CA A9              lda   c_bytes_free+2
1791 A89A E9 00 00              sbc   #$0000
1792 A89D 60                    rts   
1793 A89E
1794 A89E              ;-----------------------------------------------------------------------------
1795 A89E              ; ADD_TO_FREE -- add freed bytes back to free byte count
1796 A89E              ;
1797 A89E              ; This routine will add the number of bytes about to be released, back to
1798 A89E              ; Mike.  It's just a simple 4 byte addition.
1799 A89E              ;
1800 A89E              ; inputs: A = don't care                outputs: A = trashed
1801 A89E              ;         X = don't care                         X = trashed
1802 A89E              ;         Y = don't care                         Y = trashed
1803 A89E              ;         D = gs/os direct page                  D = i didn't change it
1804 A89E              ;         B = don't care                         B = preserved
1805 A89E              ;         K = don't care                         K = preserved
1806 A89E              ;    LCbank = don't care                    LCbank = i didn't change it 
1807 A89E              ;
1808 A89E              ; on output: c = don't care
1809 A89E              ;
1810 A89E              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1811 A89E              ; author: Ray (Rowdy Yates) Chiang
1812 A89E              ;-----------------------------------------------------------------------------
1813 A89E
1814 A89E                       EXPORT add_to_free
1815 A89E              add_to_free                             ;
1816 A89E A0 1E 00              ldy   #c_cellsize
1817 A8A1 18                    clc   
1818 A8A2 AD C8 A9              lda   c_bytes_free
1819 A8A5 77 5A                 adc   [<cache_cur_ptr],y
1820 A8A7 8D C8 A9              sta   c_bytes_free
1821 A8AA 90 03                 bcc   atf_00
1822 A8AC EE CA A9              inc   c_bytes_free+2           ;bump this for carry
1823 A8AF 60           atf_00   rts   
1824 A8B0
1825 A8B0              ;-----------------------------------------------------------------------------
1826 A8B0              ; SET_CACHE_PTR -- sets drvr_cach_ptr
1827 A8B0              ;
1828 A8B0              ; This routine will set drvr_cach_ptr, that's all.
1829 A8B0              ;
1830 A8B0              ; inputs: A = don't care                outputs: A = trashed
1831 A8B0              ;         X = don't care                         X = trashed
1832 A8B0              ;         Y = don't care                         Y = trashed
1833 A8B0              ;         D = gs/os direct page                  D = i didn't change it
1834 A8B0              ;         B = don't care                         B = preserved
1835 A8B0              ;         K = don't care                         K = preserved
1836 A8B0              ;    LCbank = don't care                    LCbank = i didn't change it 
1837 A8B0              ;
1838 A8B0              ; on output: c = don't care
1839 A8B0              ;
1840 A8B0              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1841 A8B0              ; author: Ray (Rowdy Yates) Chiang
1842 A8B0              ;-----------------------------------------------------------------------------
1843 A8B0
1844 A8B0                       EXPORT set_cache_ptr
1845 A8B0              set_cache_ptr                           ;
1846 A8B0 18                    clc   
1847 A8B1 A5 5A                 lda   <cache_cur_ptr           ;get pointer to current cache cell
1848 A8B3 69 24 00              adc   #c_headerlen             ;add to it the cache header length
1849 A8B6 85 1C                 sta   <drvr_cach_ptr           ;pointer to cached block, lo
1850 A8B8 A5 5C                 lda   <cache_cur_ptr+2
1851 A8BA 69 00 00              adc   #$0000
1852 A8BD 85 1E                 sta   <drvr_cach_ptr+2         ;pointer to cached block, hi
1853 A8BF 60                    rts   
1854 A8C0
1855 A8C0              ;-----------------------------------------------------------------------------
1856 A8C0              ; LOOK_IN_ARRAY -- looks in bucket array for an entry
1857 A8C0              ;
1858 A8C0              ; This routine will index into the bucket array for an entry.  If the entry is
1859 A8C0              ; not 0, then the block we're looking for is somewhere in that particular
1860 A8C0              ; bucket list.  If the entry is 0, then the bucket array has no knowledge of
1861 A8C0              ; the requested block.
1862 A8C0              ;
1863 A8C0              ; inputs: A = don't care                outputs: A = trashed
1864 A8C0              ;         X = don't care                         X = vp to cached block, lo
1865 A8C0              ;         Y = don't care                         Y = vp to cached block, hi
1866 A8C0              ;         D = gs/os direct page                  D = i didn't change it
1867 A8C0              ;         B = don't care                         B = preserved
1868 A8C0              ;         K = don't care                         K = preserved
1869 A8C0              ;    LCbank = don't care                    LCbank = i didn't change it 
1870 A8C0              ;
1871 A8C0              ; on output: c = 0 means there's something here, still have to traverse links
1872 A8C0              ;            c = 1 means there's no entry for this bucket index
1873 A8C0              ;
1874 A8C0              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1875 A8C0              ; author: Ray (Rowdy Yates) Chiang
1876 A8C0              ;-----------------------------------------------------------------------------
1877 A8C0
1878 A8C0                       EXPORT look_in_array
1879 A8C0              look_in_array  
1880 A8C0 20 80 A2              jsr   deref_bucket             ;Deref the bucket table and setup cache_bkt_ptr
1881 A8C3
1882 A8C3 A5 10                 lda   <drvr_blk_num            ;get block number
1883 A8C5 29 7F 00              and   #$007f                   ;keep low 7 bits
1884 A8C8 8D CE A9              sta   c_temp_element           ;save this for later
1885 A8CB 0A                    asl   a
1886 A8CC 0A                    asl   a                        ;multiply by 4 and make into index
1887 A8CD A8                    tay   
1888 A8CE
1889 A8CE B7 66                 lda   [<cache_bkt_ptr],y       ;get lo part
1890 A8D0 AA                    tax                            ;save in x
1891 A8D1 C8                    iny   
1892 A8D2 C8                    iny   
1893 A8D3 B7 66                 lda   [<cache_bkt_ptr],y       ;get hi part
1894 A8D5 D0 06                 bne   lia_00                   ;skip if <> 0
1895 A8D7 A8                    tay   
1896 A8D8 8A                    txa   
1897 A8D9 D0 03                 bne   lia_01                   ;skip if <> 0
1898 A8DB 38                    sec                            ;no entry for this block
1899 A8DC 60                    rts   
1900 A8DD
1901 A8DD A8           lia_00   tay                            ;move hi part into y
1902 A8DE 18           lia_01   clc                            ;indicate an entry found
1903 A8DF 60                    rts   
1904 A8E0
1905 A8E0              ;-----------------------------------------------------------------------------
1906 A8E0              ; WRITE_TO_DISK -- writes a block to a disk
1907 A8E0              ;
1908 A8E0              ; This routine will write a block from the cache to a block device.  The
1909 A8E0              ; blocks to be written will most likely be deferred blocks.  The block to be
1910 A8E0              ; written is pointed to by cache_cur_ptr
1911 A8E0              ;
1912 A8E0              ; inputs: A = don't care                outputs: A = don't care
1913 A8E0              ;         X = don't care                         X = don't care
1914 A8E0              ;         Y = don't care                         Y = don't care
1915 A8E0              ;         D = gs/os direct page                  D = i didn't change it
1916 A8E0              ;         B = don't care                         B = preserved
1917 A8E0              ;         K = don't care                         K = preserved
1918 A8E0              ;    LCbank = don't care                    LCbank = i didn't change it 
1919 A8E0              ;
1920 A8E0              ; on output: c = 0 means the write's successful
1921 A8E0              ;            c = 1 means the write went wrong
1922 A8E0              ;
1923 A8E0              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1924 A8E0              ; author: Ray (Rowdy Yates) Chiang
1925 A8E0              ;-----------------------------------------------------------------------------
1926 A8E0
1927 A8E0                       EXPORT write_to_disk
1928 A8E0              write_to_disk                           ;
1929 A8E0 A9 03 00              lda   #drvr_write              ;driver write command
1930 A8E3 85 02                 sta   <drvr_call_num
1931 A8E5
1932 A8E5 A0 10 00              ldy   #c_blknum                ;offset to block number, lo
1933 A8E8 B7 5A                 lda   [<cache_cur_ptr],y
1934 A8EA 85 10                 sta   <drvr_blk_num
1935 A8EC C8                    iny   
1936 A8ED C8                    iny                            ;offset to block number, hi
1937 A8EE B7 5A                 lda   [<cache_cur_ptr],y
1938 A8F0 85 12                 sta   <drvr_blk_num+2
1939 A8F2
1940 A8F2 38                    sec   
1941 A8F3 A0 1E 00              ldy   #c_cellsize              ;offset to size of cache cell
1942 A8F6 B7 5A                 lda   [<cache_cur_ptr],y
1943 A8F8 E9 24 00              sbc   #c_headerlen             ;subtract away the cache header
1944 A8FB 85 08                 sta   <drvr_req_cnt            ;want to write this many bytes
1945 A8FD
1946 A8FD 18                    clc   
1947 A8FE A5 5A                 lda   <cache_cur_ptr
1948 A900 69 24 00              adc   #c_headerlen             ;point past the cacher header
1949 A903 85 04                 sta   <drvr_buf_ptr            ;data starts here, lo
1950 A905 A5 5C                 lda   <cache_cur_ptr+2
1951 A907 69 00 00              adc   #$0000
1952 A90A 85 06                 sta   <drvr_buf_ptr+2          ;data starts here, hi
1953 A90C
1954 A90C              ; i think we got everything ready for a write, let's do it
1955 A90C
1956 A90C 22 00 FC 01           jsl   dev_dispatcher
1957 A910 60                    rts                            ;result in a and c
1958 A911
1959 A911              ;-----------------------------------------------------------------------------
1960 A911              ; CACHE_ERROR -- exits to the caller
1961 A911              ;
1962 A911              ; This routine will exit back to the caller because of some sort of error.
1963 A911              ; The error usually results from fiddling with the mike memory manager or
1964 A911              ; the LRU or bucket links are trashed.  This shouldn't happen though . . .
1965 A911              ;
1966 A911              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
1967 A911              ; author: Ray (Rowdy Yates) Chiang
1968 A911              ;-----------------------------------------------------------------------------
1969 A911
1970 A911                       EXPORT cache_error
1971 A911              cache_error                             ;
1972 A911 AB                    plb                            ;restore caller's data bank
1973 A912 38                    sec                            ;indicate an error
1974 A913 6B                    rtl                            ;go back with bad news
1975 A914
1976 A914                       ENDP 
1977 A914
1978 A914              ;-----------------------------------------------------------------------------
1979 A914              ; Cache_In_Queue -- 
1980 A914              ;
1981 A914              ; This routine will add a task in the OutOfMemory queue routine.  If the
1982 A914              ; memory manager runs out of memory then I will purge the cache.
1983 A914              ;
1984 A914              ;-----------------------------------------------------------------------------
1985 A914
1986 A914                       EXPORT Cache_In_Queue              
1987 A914              Cache_In_Queue Proc 
1988 A914
1989 A914 AF AE A9 00           lda   >InQueueAlready          ;See if I am already in the queue
1990 A918 30 14                 bmi   @skip_add                ;I am already in the queue thank you very much.
1991 A91A
1992 A91A F4 00 00              pea   MyOutOfMemRoutine>>16
1993 A91D F4 4F A9              pea   MyOutOfMemRoutine
1994 A920 A2 02 0C              ldx   #$0C02                   ;AddToOOMQueue
1995 A923 22 00 00 E1           jsl   $e10000
1996 A927 A9 FF FF              lda   #$FFFF
1997 A92A 8F AE A9 00           sta   >InQueueAlready
1998 A92E 6B           @skip_add rtl                           ;return to the caller
1999 A92F
2000 A92F                       Export Cache_out_of_Queue
2001 A92F              Cache_out_of_Queue  
2002 A92F A5 30                 lda   call_number              ;is this a Reset_Cache Call?
2003 A931 C9 26 20              cmp   #$2026
2004 A934 F0 18                 beq   @skip_remove             ;It sure is so don't do anything
2005 A936
2006 A936 AD AE A9              lda   InQueueAlready           ;Am I in the queue?
2007 A939 F0 13                 beq   @skip_remove
2008 A93B
2009 A93B F4 00 00              pea   MyOutOfMemRoutine>>16
2010 A93E F4 4F A9              pea   MyOutOfMemRoutine
2011 A941 A2 02 0D              ldx   #$0D02                   ;DeleteFromOOMQueue
2012 A944 22 00 00 E1           jsl   $e10000
2013 A948 A9 00 00              lda   #$0000                   ;zero the InQueue Flag
2014 A94B 8D AE A9              sta   InQueueAlready
2015 A94E
2016 A94E 60           @skip_remove rts   
2017 A94F
2018 A94F              MyOutOfMemRoutine  
2019 A94F 6F F3 04 00           DC L:000000                    ;Used by the Queue Manager?
2020 A953              cache_reset_list                        ;zero PCount for reset cache call
2021 A953 00 00                 DC W:0000                      ;Doubles as ResetCacheList and Queue Header
2022 A955 5A A5                 DC W:$A55A
2023 A957
2024 A957              RTLAddr  equ   1
2025 A957              stage    equ   RTLAddr+3                ;First or second stage of calls
2026 A957              BytesNeeded equ   stage+2               ;Number of bytes the memory manager needs
2027 A957              Result   equ   BytesNeeded+4            ;Number of bytes I have freed up!
2028 A957              active_flag equ   $e100Be               ;OS active flag: BIT 15 set to 1 = busy
2029 A957
2030 A957              ;
2031 A957              ;Lets zap the results please
2032 A957              ;
2033 A957 A9 00 00              lda   #$0000
2034 A95A 83 0A                 sta   Result,s
2035 A95C 83 0C                 sta   Result+2,s               ;tell Memory Manger Nothing yet.
2036 A95E              ;
2037 A95E              ;See if the OS busy first.  If it is then we let the OS deal with the situation.
2038 A95E              ;
2039 A95E AF BE 00 E1           lda   >active_flag             ;is the OS Busy???
2040 A962 30 04                 bmi   @end_mem                 ;Yep it sure is.
2041 A964              ;
2042 A964              ;See if we are being called before or after purging data.
2043 A964              ;
2044 A964
2045 A964 A3 04                 lda   stage,s
2046 A966 F0 0C                 beq   @do_free                 ;only free before purging....
2047 A968              @end_mem  
2048 A968                       longa off
2049 A968 E2 20                 sep   #$20                     ;8 bit mode please
2050 A96A              ;
2051 A96A              ;Get return address
2052 A96A              ;
2053 A96A 68                    pla   
2054 A96B 7A                    ply   
2055 A96C              ;
2056 A96C              ;Remove size bytes of parameters
2057 A96C              ;
2058 A96C FA                    plx   
2059 A96D FA                    plx   
2060 A96E FA                    plx   
2061 A96F
2062 A96F 5A                    phy   
2063 A970 48                    pha   
2064 A971                       longa on
2065 A971 C2 20                 rep   #$20                     ;back to caller
2066 A973 6B                    rtl   
2067 A974
2068 A974              @do_free  
2069 A974 8B                    phb   
2070 A975 4B                    phk   
2071 A976 AB                    plb   
2072 A977
2073 A977 20 9E A9              jsr   GetFreeMem               ;go get the count please A=Low, Y=High
2074 A97A 8D AA A9              sta   curr_free_mem            ;the current state of memory
2075 A97D 8C AC A9              sty   curr_free_mem+2
2076 A980              ;
2077 A980              ;Now what we do is issue a Reset Cache Call to GS/OS
2078 A980              ;
2079 A980 22 A8 00 E1           jsl   $e100a8
2080 A984 26 20                 DC W:$2026                     ;reset cache call
2081 A986 53 A9 00 00           DC L:cache_reset_list
2082 A98A
2083 A98A 20 9E A9              jsr   GetFreeMem               ;A=Low, Y=High
2084 A98D 38                    sec   
2085 A98E ED AA A9              sbc   curr_free_mem            ;get the new memory count please
2086 A991 AA                    tax   
2087 A992 98                    tya   
2088 A993 ED AC A9              sbc   curr_free_mem+2
2089 A996
2090 A996 AB                    plb                            ;reset the bank register please
2091 A997 83 0C                 sta   result+2,s               ;save the high word of newly freed memory
2092 A999 8A                    txa   
2093 A99A 83 0A                 sta   result,s
2094 A99C 80 CA                 bra   @end_mem                 ;return to the caller
2095 A99E
2096 A99E              GetFreeMem  
2097 A99E 48                    pha   
2098 A99F 48                    pha                            ;lets see how much memory is free right now.
2099 A9A0 A2 02 1B              ldx   #$1b02                   ;Get FREEMEM call
2100 A9A3 22 00 00 E1           jsl   $e10000
2101 A9A7
2102 A9A7 68                    pla                            ;get the low word
2103 A9A8 7A                    ply   
2104 A9A9 60                    rts   
2105 A9AA
2106 A9AA 00 00 00 00  curr_free_mem DC L:00
2107 A9AE FF FF        InQueueAlready DC W:00                  ;indicates if I am installed in the Queue.
2108 A9B0                       endp 
2109 A9B0
2110 A9B0
2111 A9B0              ;-----------------------------------------------------------------------------
2112 A9B0              ; DATA
2113 A9B0              ;
2114 A9B0              ; Note: every variable better be an even number of bytes.
2115 A9B0              ;
2116 A9B0              ; cache_cur_ptr, cache_nxt_ptr, cache_pre_ptr and cache_bkt_ptr are in
2117 A9B0              ; GS/OS direct page
2118 A9B0              ;
2119 A9B0              ; Copyright (c) 1987 Apple Computer Inc. All rights reserved.
2120 A9B0              ; author: Ray (Rowdy Yates) Chiang
2121 A9B0              ;-----------------------------------------------------------------------------
2122 A9B0
2123 A9B0                       EXPORT cache_data
2124 A9B0              cache_data PROC 
2125 A9B0
2126 A9B0                       EXPORT start_of_data
2127 A9B0              start_of_data                           ;               
2128 A9B0                       EXPORT head_vp
2129 A9B0 7F 0C 14 00  head_vp  DS B:4                         ;vp to head of LRU list
2130 A9B4                       EXPORT tail_vp
2131 A9B4 DF 10 18 00  tail_vp  DS B:4                         ;vp to tail of LRU list
2132 A9B8                       EXPORT current_vp
2133 A9B8 7F 0C 14 00  current_vp DS B:4                       ;vp to current cache cell
2134 A9BC                       EXPORT next_vp
2135 A9BC CE 1D 18 00  next_vp  DS B:4                         ;vp to next cache cell
2136 A9C0                       EXPORT prev_vp
2137 A9C0 1E 0A 10 00  prev_vp  DS B:4                         ;vp to previous cache cell
2138 A9C4                       EXPORT bucket_vp
2139 A9C4 DE 1D 04 00  bucket_vp DS B:4                        ;vp to bucket vps
2140 A9C8                       EXPORT c_bytes_free
2141 A9C8 D8 01 00 00  c_bytes_free DS B:4                     ;number of bytes free in cache
2142 A9CC                       EXPORT c_request_size
2143 A9CC 24 02        c_request_size DS B:2                   ;current request size
2144 A9CE                       EXPORT c_temp_element
2145 A9CE 04 00        c_temp_element DS B:2                   ;temp for bucket element
2146 A9D0                       EXPORT c_temp_fwd
2147 A9D0 00 00        c_temp_fwd DS B:2                       ;temp for  forward vp link
2148 A9D2                       EXPORT c_temp_bwd
2149 A9D2 04 00        c_temp_bwd DS B:2                       ;temp for backward vp link
2150 A9D4                       EXPORT c_temp_1
2151 A9D4 00 00        c_temp_1 DS B:2                         ;temp for device number or FST offset
2152 A9D6                       EXPORT c_temp_2
2153 A9D6 00 00        c_temp_2 DS B:2                         ;temp for device number or FST value
2154 A9D8                       EXPORT c_temp_nvp
2155 A9D8 00 00 00 00  c_temp_nvp DS B:4                       ;temp for next_vp
2156 A9DC                       EXPORT c_marker
2157 A9DC 71 00        c_marker DS B:2                         ;temp for debugging
2158 A9DE                       EXPORT no_find
2159 A9DE 00 00        no_find  DS B:2                         ;flag for enable/disable find routine
2160 A9E0                       EXPORT message_shown
2161 A9E0 00 00        message_shown DS B:2                    ;flag to indicate deferred blocks
2162 A9E2              ;                                       ;have been flushed and user was told
2163 A9E2                       export in_queue
2164 A9E2
2165 A9E2 00 00        in_queue DC W:$0000
2166 A9E4                       EXPORT end_of_data
2167 A9E4              end_of_data  
2168 A9E4                       export c_data_len:equ
2169 A9E4              c_data_len equ   end_of_data-start_of_data-1
2170 A9E4
2171 A9E4                       ENDP 
